# Site Logo Upload Functionality

## Overview
The site now has a comprehensive dynamic logo upload system that allows administrators to upload and manage site logos for different themes and states through the admin panel.

## Features

### 1. Logo Types
- **Site Logo (For Dark Backgrounds)**: Logo designed for dark backgrounds (shows in light theme) (recommended size: 110x32px)
- **Site Logo (For Light Backgrounds)**: Logo designed for light backgrounds (shows in dark theme) (recommended size: 110x32px)
- **Site Small Logo (For Dark Backgrounds)**: Small logo for dark backgrounds (shows in light theme sidebar/collapsed state) (recommended size: 30x30px)
- **Site Small Logo (For Light Backgrounds)**: Small logo for light backgrounds (shows in dark theme sidebar/collapsed state) (recommended size: 30x30px)
- **Site Favicon**: Browser tab icon (recommended size: 32x32px or 16x16px)

### 2. Supported Formats
- **Images**: JPEG, PNG, GIF, SVG
- **Favicon**: ICO, PNG, JPEG, GIF
- **Maximum file size**: 10MB per file

### 3. Dynamic Implementation
- All layout files now use dynamic logos based on theme and state
- Fallback to default static logos if no custom logo is uploaded
- Logos are stored in `storage/app/public/logos/` directory
- Database settings store the file paths

## How to Use

### Accessing Logo Settings
1. Login to the admin panel
2. Navigate to **Settings** → **Appearance**
3. You'll see five sections for logo uploads

### Uploading Logos
1. Click "Choose File" for the logo type you want to upload
2. Select your image file
3. Click "Update" to save changes
4. The logo will be immediately visible in the preview

### Deleting Logos
1. If a logo is already uploaded, you'll see a "Delete" button next to the preview
2. Click "Delete" and confirm to remove the logo
3. The system will fall back to default static logos

## Technical Implementation

### Files Modified
- `app/Http/Controllers/Admin/SettingController.php` - Enhanced upload logic for all logo types
- `resources/views/admin/settings/appearance.blade.php` - Comprehensive admin interface
- `resources/views/layouts/backend/*.blade.php` - Dynamic logo implementation for all themes
- `routes/web.php` - Added delete route

### Database
- Settings are stored in the `settings` table
- Keys: `site_logo_light`, `site_logo_dark`, `site_logo_small_light`, `site_logo_small_dark`, `site_favicon`

### Storage
- Files are stored in `storage/app/public/logos/`
- Old files are automatically deleted when new ones are uploaded

## Layout Integration

### Header Logos
All layout files now check for dynamic logos based on theme:
```php
@if(setting('site_logo_light') && setting('site_logo_dark'))
    <img src="{{ Storage::url(setting('site_logo_light')) }}" class="desktop-logo" alt="logo">
    <img src="{{ Storage::url(setting('site_logo_dark')) }}" class="light-logo1" alt="logo">
@elseif(setting('site_logo_light'))
    <img src="{{ Storage::url(setting('site_logo_light')) }}" class="desktop-logo" alt="logo">
    <img src="{{ Storage::url(setting('site_logo_light')) }}" class="light-logo1" alt="logo">
@else
    <img src="{{ asset('assets/images/brand/logo-white.png') }}" class="desktop-logo" alt="logo">
    <img src="{{ asset('assets/images/brand/logo-dark.png') }}" class="light-logo1" alt="logo">
@endif
```

### Sidebar Logos (Collapsed State)
Smart logo selection for collapsed sidebar:
```php
@if(setting('site_logo_light') && setting('site_logo_dark') && setting('site_logo_small_light') && setting('site_logo_small_dark'))
    <img src="{{ Storage::url(setting('site_logo_light')) }}" class="desktop-logo" alt="logo">
    <img src="{{ Storage::url(setting('site_logo_small_light')) }}" class="toggle-logo" alt="logo">
    <img src="{{ Storage::url(setting('site_logo_small_dark')) }}" class="light-logo" alt="logo">
    <img src="{{ Storage::url(setting('site_logo_dark')) }}" class="light-logo1" alt="logo">
@elseif(setting('site_logo_light') && setting('site_logo_dark'))
    <!-- Fallback to main logos if small logos not available -->
@endif
```

### Favicon
Dynamic favicon implementation:
```php
<link rel="shortcut icon" type="image/x-icon" href="{{ setting('site_favicon') ? Storage::url(setting('site_favicon')) : asset('assets/images/brand/favicon.ico') }}">
```

## Logo Class Mapping

### CSS Classes Used
- **`desktop-logo`**: Main logo for desktop view (light theme)
- **`light-logo1`**: Main logo for light theme backgrounds
- **`toggle-logo`**: Small logo for collapsed sidebar (light theme)
- **`light-logo`**: Small logo for collapsed sidebar (dark theme)

### Theme Logic
- **Light Theme**: Uses logos designed for dark backgrounds (`.light-logo1` class)
- **Dark Theme**: Uses logos designed for light backgrounds (`.desktop-logo` class)
- **Collapsed Sidebar**: Uses small logos based on current theme

## Benefits
1. **Complete Theme Support**: Separate logos for light and dark themes
2. **Collapsed State Support**: Dedicated small logos for sidebar collapse
3. **Dynamic Branding**: Easy logo changes without code deployment
4. **Smart Fallbacks**: Graceful degradation to default logos
5. **User-Friendly Interface**: Intuitive upload and management
6. **File Management**: Automatic cleanup of old files
7. **Validation**: Proper file type and size validation

## Troubleshooting

### Logo Not Displaying
1. Check if the logo was uploaded successfully
2. Verify the file is in `storage/app/public/logos/`
3. Ensure the storage link is created: `php artisan storage:link`
4. Check file permissions

### Upload Errors
1. Verify file size is under 10MB
2. Check file format is supported
3. Ensure `storage/app/public/logos/` directory exists and is writable

### Theme Issues
1. Make sure you have uploaded logos for both light and dark themes
2. Check if the theme switching is working properly
3. Verify CSS classes are being applied correctly

### Cache Issues
If logos don't update immediately:
1. Clear browser cache
2. Run `php artisan cache:clear`
3. Check if CDN caching is affecting the display
