<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    protected $fillable = ['name', 'code'];
    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function offers()
    {

        return $this->hasMany(Offer::class, 'country_id', 'id');
    }

    public function countryPayout()
    {
        return $this->belongsTo(CountryPayout::class, 'id', 'country_id');
    }

    public function coustomCountryPayout()
    {
        return $this->belongsTo(CoustomCountryPayout::class, 'id', 'country_id');
    }
    public function reports()
    {
        return $this->hasMany(Report::class);
    }

}
