<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CountryPayout extends Model
{
    protected $guarded = ['id'];

    public function offer()
    {
        return $this->belongsTo(Offer::class);
    }

    public function country()
    {
        return $this->hasOne(Country::class, 'id', 'country_id');
    }

    public function devices()
    {
        return $this->hasMany(DevicePayout::class);
    }
}
