<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CoustomCountryPayout extends Model
{
    protected $guarded = ['id'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function country()
    {
        return $this->hasOne(Country::class,'id','country_id');
    }

    public function offer()
    {
        return $this->belongsTo(Offer::class);
    }

    public function devices()
    {
        return $this->hasMany(CoustomCountryDevicePayout::class,'coustom_country_payout_id','id');
    }
}
