<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Device extends Model
{
    public function offers()
    {
        return $this->hasMany(Offer::class, 'device_id');
    }

    public function payout()
    {
        return $this->belongsTo(DevicePayout::class, 'device_id');
    }

    public function coustomDevicePayout()
    {
        return $this->belongsTo(CoustomCountryDevicePayout::class);
    }
}
