<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Finance extends Model implements HasMedia
{
    use InteractsWithMedia;
    protected $guarded = ['id'];

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('avater')->singleFile();
    }
    public function paymentMethods()
    {
        return $this->hasMany(PaymentMethod::class);
    }
}
