<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class FruadReport extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
       /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'affiliate_id',
        'offer_id',
        'proxy',
        'ISP',
        'organization',
        'ASN',
        'host',
        'country_code',
        'city',
        'region',
        'is_crawler',
        'connection_type',
        'zip_code',
        'timezone',
        'vpn',
        'tor',
        'active_vpn',
        'active_tor',
        'recent_abuse',
        'frequent_abuser',
        'high_risk_attacks',
        'abuse_velocity',
        'bot_status',
        'shared_connection',
        'dynamic_connection',
        'security_scanner',
        'trusted_network',
        'mobile',
        'fraud_score',
        'operating_system',
        'browser',
        'device_model',
        'device_brand',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'proxy' => 'boolean',
        'is_crawler' => 'boolean',
        'vpn' => 'boolean',
        'tor' => 'boolean',
        'active_vpn' => 'boolean',
        'active_tor' => 'boolean',
        'recent_abuse' => 'boolean',
        'frequent_abuser' => 'boolean',
        'high_risk_attacks' => 'boolean',
        'bot_status' => 'boolean',
        'shared_connection' => 'boolean',
        'dynamic_connection' => 'boolean',
        'security_scanner' => 'boolean',
        'trusted_network' => 'boolean',
        'mobile' => 'boolean',
        'fraud_score' => 'integer',
    ];

    /**
     * Get the user (affiliate) associated with the fraud report.
     */
    public function affiliate()
    {
        return $this->belongsTo(User::class, 'affiliate_id');
    }

    /**
     * Get the offer associated with the fraud report.
     */
    public function offer()
    {
        return $this->belongsTo(Offer::class, 'offer_id');
    }
}
