<?php

use App\ReferCommission;
use App\Setting;
use App\User;

function settingValue($key){
    $setting = Setting::where('name', $key)->first();
    return $setting ? $setting->value : null;
}

function commission_percent(){
    $percent = settingValue('refer_commission');

    if($percent !== null && is_numeric($percent) && $percent > 0) {
        return $percent;
    }else{
        return 0;
    }
}

function commission($amount) {
    $percent = commission_percent();
    $commission = ($amount * $percent) / 100;
    return $commission;
}

function referedCommission($userid,$id){
    $amount=ReferCommission::where('user_id',$userid)->where('refered_user',$id)->where('action','confirm')->sum('amount');
    return $amount;
}

function commissionAdd($amount,$rferid, $userId){
    $user = User::find($rferid);
    if(!$user) {
        return;
    }

    $percent = settingValue('refer_commission');

    if($percent !== null && is_numeric($percent) && $percent > 0) {
        $commission = commission($amount) * ($percent / 100);
        $user->balance += $commission;
        $user->save();

        ReferCommission::create([
            'user_id'=>$user->id,
            'refered_user'=>$userId,
            'amount'=>$commission,
            'action'=>'Confirm',
        ]);
    }
}

function decreaseReferCommission($amount,$rferid, $userId){
    $user = User::find($rferid);
    if(!$user) {
        return;
    }

    $percent = settingValue('refer_commission');

    if($percent !== null && is_numeric($percent) && $percent > 0) {
        // Calculate the commission to be decreased
        $commission = commission($amount) * ($percent / 100);

        // Check if the user has sufficient referral commission
        if($user->refer_commission >= $commission) {
            $user->refer_commission -= $commission;
            $user->save();

            ReferCommission::create([
                'user_id'=>$user->id,
                'refered_user'=>$userId,
                'amount'=>$commission,
                'action'=>'Rejected',
            ]);
        } else {
            // Handle case where referral commission is insufficient
            return;
        }
    }
}



