<?php

namespace App\Http\Controllers\Admin;

use App\Country;
use App\Finance;
use App\Http\Controllers\Controller;
use App\Http\Requests\AffiliateProfileUpdate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AccountController extends Controller
{
    public function index()
    {
        $countries = Country::all();
        $finances = Finance::all();
        return view('admin.account.index',compact('countries','finances'));
    }

    public function update(AffiliateProfileUpdate $request)
    {
        $user = Auth::user();
    
        // Update profile data
        $user->update([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'country_id' => $request->country_id,
            'skype' => $request->skype,
        ]);
    
        try {
            // Check if a new avatar file is provided
            if ($request->hasFile('avater')) {
                
                $user->addMedia($request->file('avater'))->toMediaCollection('avater');
            }
        } catch (\Exception $e) {
            return back()->with('error', 'An error occurred while uploading the avatar.');
        }
        
    
        // Check if the password is being updated
        if ($request->filled('password')) {
            $this->validate($request, [
                'password' => 'required|min:6|confirmed',
            ]);
    
            // Check if the old password matches the user's current password
            if (\Hash::check($request->old_password, $user->password)) {
                // Check if the new password is different from the old password
                if (!\Hash::check($request->password, $user->password)) {
                    $user->update([
                        'password' => \Hash::make($request->password),
                    ]);
                    return back()->with('success', 'Password changed successfully');
                } else {
                    return back()->with('error', 'New password cannot be the same as the old password');
                }
            } else {
                return back()->with('error', 'Old password is incorrect');
            }
        }
    
        return back()->with('success', 'Profile updated successfully');
    }
    
}
