<?php

namespace App\Http\Controllers\Admin;

use App\Advertiser;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AdvertiserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $advertisers = Advertiser::orderBy('id','desc')->paginate(20);
        return view('admin.advertiser.index',compact('advertisers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.advertiser.form');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name' => 'required|unique:advertisers',
        ]);
        Advertiser::create($request->all());
        return redirect()->route('admin.advertiser.index')->with('success','Advertiser created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $advertiser = Advertiser::findOrFail($id);
        return view('admin.advertiser.form',compact('advertiser'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name' => 'required|unique:advertisers,name,'.$id,
        ]);
        $advertiser = Advertiser::findOrFail($id);
        $advertiser->update($request->all());
        return redirect()->route('admin.advertiser.index')->with('success','Advertiser updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $advertiser = Advertiser::findOrFail($id);
        $advertiser->delete();
        return redirect()->route('admin.advertiser.index')->with('success','Advertiser deleted successfully');
    }
}
