<?php

namespace App\Http\Controllers\Admin;

use App\Finance;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class FinanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $finances = Finance::all();
        return view('admin.finance.index', compact('finances'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.finance.form');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'description' => 'required',
            'avater' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
       $finance = Finance::create($request->all());
        if($request->hasFile('avater'))
        {
            $finance->addMedia($request->avater)->toMediaCollection('avater');
        }
        return redirect()->route('admin.finance.index')->with('success', 'Finance created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $finance = Finance::find($id);
        return view('admin.finance.form', compact('finance'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'description' => 'required',
            'avater' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        $finance = Finance::find($id);
        $finance->update($request->all());
        if($request->hasFile('avater'))
        {
            $finance->addMedia($request->avater)->toMediaCollection('avater');
        }
        return redirect()->route('admin.finance.index')->with('success', 'Finance updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $finance = Finance::find($id);
        $finance->delete();
        return redirect()->route('admin.finance.index')->with('success', 'Finance deleted successfully');
    }
}
