<?php

namespace App\Http\Controllers\Admin;

use App\FruadReport;
use App\Http\Controllers\Controller;
use App\Offer;
use App\User;
use Illuminate\Http\Request;

class FraudController extends Controller
{
    public function index(Request $request)
    {
        // Fetch all affiliates and offers
        $affiliates = User::where('role', 'affiliate')->where('status', 'active')->get();
        $offers = Offer::where('status', 'active')->get();

        // Fetch fraud reports with conditional filters
        $frauds = FruadReport::when($request->has('affiliate_id'), function ($query) use ($request) {
            $query->where('affiliate_id', $request->input('affiliate_id'));
        })
            ->when($request->has('offer_id'), function ($query) use ($request) {
                $query->where('offer_id', $request->input('offer_id'));
            })->latest()
            ->paginate(20);

        return view('admin.fraud.index', compact('frauds', 'affiliates', 'offers'));
    }

}
