<?php

namespace App\Http\Controllers\Admin;

use App\User;
use App\Country;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\CreateManager;
use App\Http\Requests\UpdateManager;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\RegisterRequest;
use App\Http\Requests\UserUpdateRequest;
use App\Notifications\AdminAffiliateCreate;
use Illuminate\Support\Facades\Notification;

class ManagerController extends Controller
{
    public function index(Request $request)
    {
        $name = '';
        $email = '';
        $country_id = [];
        $status = '';
        if ($request->filter) {
            $name = request()->get('name');
            $email = request()->get('email');
            $country_id = request()->get('country_id');
            $status = request()->get('status');
            $managers = User::where('role','manager')
                ->when($status, function ($query) use ($status) {
                    return $query->where('status', $status);
                })->when($name, function ($query) use ($name) {
                    return $query->where('first_name', 'like', '%' . $name . '%')->orWhere('last_name', 'like', '%' . $name . '%');
                })->when($email, function ($query) use ($email) {
                    return $query->where('email', 'like', '%' . $email . '%');
                })->when($country_id, function ($query) use ($country_id) {
                    return $query->whereIn('country_id', $country_id);
                })->paginate(20);
        }else{
            $managers = User::where('role','manager')->paginate(20);
        }
        $countries = Country::all();
        return view('admin.manager.index',compact('countries','managers','managers'));
    }

    public function create()
    {
        $countries = Country::all();
        $managers = User::where('role','manager')->get();
        return view('admin.manager.form',compact('countries','managers'));
    }

public function store(CreateManager $request)
{
    // Create a new User instance for the manager
    $manager = new User();
    $manager->first_name = $request->first_name;
    $manager->last_name = $request->last_name;
    $manager->email = $request->email;
    $manager->country_id = $request->country_id;
    $manager->skype = $request->skype;
    $manager->status = $request->status;
    $manager->role = 'manager';
    $manager->password = bcrypt($request->password);
    $manager->comission = $request->comission;

    // Save the manager
    $manager->save();

    // Check if there is an avatar file and add it to media collection
    if ($request->hasFile('avater')) {
        $manager->addMedia($request->avater)->toMediaCollection('avater');
    }

    // Redirect with success message
    return redirect()->route('admin.manager.index')->with('success', 'Manager created successfully!');
}

public function update(UpdateManager $request, $id)
{
    // Find the existing manager by ID
    $affiliate = User::findOrFail($id);

    // Update manager attributes manually
    $affiliate->first_name = $request->first_name;
    $affiliate->last_name = $request->last_name;
    $affiliate->email = $request->email;
    $affiliate->country_id = $request->country_id;
    $affiliate->skype = $request->skype;
    $affiliate->status = $request->status;
    $affiliate->comission = $request->comission;

    // Update the password if provided
    if ($request->password) {
        $this->validate($request, [
            'password' => 'required|min:6|confirmed',
        ]);
        $affiliate->password = bcrypt($request->password);
    }

    // Save the updated manager
    $affiliate->save();

    // Check if there is an avatar file and update the media collection
    if ($request->hasFile('avater')) {
        $affiliate->addMedia($request->avater)->toMediaCollection('avatar');
    }

    // Redirect with success message
    return redirect()->route('admin.manager.index')->with('success', 'Manager updated successfully!');
}

    public function edit($id)
    {
        $manager = User::findOrFail($id);
        $countries = Country::all();
        return view('admin.manager.form',compact('manager','countries'));
    }



    public function delete($id)
    {
        User::findOrFail($id)->delete();
        return back()->with('success','Manager deleted successfully!');
    }

    // Switcing
    public function rollback( Request $request ) {

        if( ! session()->has('orig_user')){
            return back();
        }

        Auth::loginUsingId(session()->get('orig_user'));

        session()->forget('orig_user');

        return redirect()->route('admin.manager.index');

    }
    public function switch(Request $request, $id) {

        if( auth()->id() != $id ) {

            session()->put( 'orig_user', auth()->id() );

            $user = Auth::loginUsingId($id);
        }

        return redirect()->route('manager.dashboard');
    }
}
