<?php

namespace App\Http\Controllers\Admin;

use App\Advertiser;
use App\Category;
use App\Country;
use App\Device;
use App\Verticle;
use App\Http\Controllers\Controller;
use App\Http\Requests\CreateOffer;
use App\Http\Requests\UpdateOffer;
use App\Notifications\OfferApplicationApproved;
use App\Offer;
use App\OfferApplication;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;

class OfferController extends Controller
{
    public function index(Request $request)
    {
        $name = '';
        $category_id = [];
        $country_id = [];
        $status = '';
        $advertiser_id = [];
        $type = '';
        if ($request->filter) {
            $status = $request->status ?? $status;
            $category_id = $request->category_id;
            $country_id = $request->country_id;
            $name = $request->name;
            $type = $request->get('type');
            $offers = Offer::when($status, function ($query) use ($status) {
                return $query->where('status', $status);
                })->when($type, function ($query) use ($type) {
                return $query->where('type',$type);
            })
                ->when($name, function ($query) use ($name) {
                    return $query->where('name', 'like', '%' . $name . '%')->orWhere('id', $name);
                })->when($category_id, function ($query) use ($category_id) {
                    return $query->where('category_id', $category_id);
                })->when($country_id, function ($query) use ($advertiser_id) {
                return $query->whereHas('advertiser', function ($query) use ($advertiser_id) {
                    $query->whereIn('advertiser_id', $advertiser_id);
                });
            })->when($country_id, function ($query) use ($country_id) {
                    return $query->whereHas('countries', function ($query) use ($country_id) {
                        $query->whereIn('country_id', $country_id);
                    });
                })->paginate(10);
        }else {
            $offers = Offer::orderBy('id','desc')->paginate(20);
        }

        $categories = Category::all();
        $advertisers = Advertiser::all();
        $countries = Country::all();
        $devices = Device::all();

        return view('admin.offer.index',compact('offers','categories','advertisers','countries','devices'));
    }

    public function create()
    {
        $countries = Country::all();
        $devices = Device::all();
        $categories = Category::all();
        $advertisers = Advertiser::all();
        $alt_offers = Offer::where('type','smartlink')->get();
        $verticles = Verticle::all();
        return view('admin.offer.form',compact('countries','devices','categories','advertisers','alt_offers','verticles'));
    }

public function store(CreateOffer $request)
{
    // Create a new Offer instance
    $offer = new Offer();
    $offer->advertiser_id = $request->advertiser_id;
    $offer->category_id = $request->category_id;
    $offer->name = $request->name;
    $offer->description = $request->description;
    $offer->preview_link = $request->preview_link;
    $offer->tracking_link = $request->tracking_link;
    $offer->type = $request->type;
    $offer->status = $request->status;
    $offer->revenue = $request->revenue;
    $offer->payout = $request->payout;
    $offer->conversion_status = $request->conversion_status;
    $offer->daily_cap = $request->daily_cap;
    $offer->expiration_date = $request->expiration_date;
    $offer->verticle_id = $request->verticle_id;
    $offer->is_smart = $request->is_smart ?? 0;
    $offer->top_offer = $request->top_offer ?? 0;
    $offer->traffic_allowed=$request->traffic_allowed?implode(',',$request->traffic_allowed):null;
    // Save the offer
    $offer->save();

    // Attach countries and devices
    $countries = $request->country_id;
    $devices = $request->device_id;
    $offer->countries()->attach($countries);
    $offer->devices()->attach($devices);

    // Check if there is an avatar file and add it to media collection
    if ($request->hasFile('avater')) {
        $offer->addMedia($request->avater)->toMediaCollection('avater');
    }

    // Redirect to the offer index with success message
    return redirect()->route('admin.offer.index')->with('success', 'Offer Created Successfully');
}


    public function show($id)
    {
        $offer = Offer::findOrFail($id);
        $affiliates = User::where('role','affiliate')->get();
        return view('admin.offer.show',compact('offer','affiliates'));
    }

    public function edit($id)
    {
        $countries = Country::all();
        $devices = Device::all();
        $categories = Category::all();
        $advertisers = Advertiser::all();
        $alt_offers = Offer::where('type','smartlink')->get();
        $offer = Offer::find($id);
         $verticles = Verticle::all();
        return view('admin.offer.form',compact('offer','countries','devices','categories','advertisers','alt_offers','verticles'));
    }

public function update(UpdateOffer $request, $id)
{
    // Find the existing offer by ID
    $offer = Offer::find($id);

    // Update the offer attributes manually
    $offer->advertiser_id = $request->advertiser_id;
    $offer->category_id = $request->category_id;
    $offer->name = $request->name;
    $offer->description = $request->description;
    $offer->preview_link = $request->preview_link;
    $offer->tracking_link = $request->tracking_link;
    $offer->type = $request->type;
    $offer->status = $request->status;
    $offer->revenue = $request->revenue;
    $offer->payout = $request->payout;
    $offer->conversion_status = $request->conversion_status;
    $offer->daily_cap = $request->daily_cap;
    $offer->expiration_date = $request->expiration_date;
    $offer->verticle_id = $request->verticle_id;
    $offer->is_smart = $request->is_smart ?? 0;
    $offer->top_offer = $request->top_offer ?? 0;
    $offer->traffic_allowed=$request->traffic_allowed?implode(',',$request->traffic_allowed):null;


    // Save the changes to the offer
    $offer->save();

    // Check if there is an avatar file and update the media collection
    if ($request->hasFile('avater')) {
        $offer->addMedia($request->avater)->toMediaCollection('avater');
    }

    // Sync countries and devices with the updated data
    $countries = $request->country_id;
    $devices = $request->device_id;
    $offer->countries()->sync($countries);
    $offer->devices()->sync($devices);

    // Redirect to the offer index with a success message
    return redirect()->route('admin.offer.index')->with('success', 'Offer Updated Successfully');
}


    public function destroy($id)
    {
        $offer = Offer::find($id);
        $offer->countries()->detach();
        $offer->devices()->detach();
        $offer->delete();
        return redirect()->route('admin.offer.index')->with('success','Offer Deleted Successfully');
    }
    public function application(Request $request)
    {
        $user_id = [];
        $offer_id = [];
        if ($request->filter) {
            $user_id = $request->get('user_id');
            $offer_id = $request->get('offer_id');
            $applications = OfferApplication::where('status','false')->orderBy('id', 'DESC')
                ->when($user_id, function ($query, $user_id) {
                    return $query->whereIn('user_id', $user_id);
                })->when($offer_id, function ($query, $offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                })->paginate(20);
        }else{
            $applications = OfferApplication::where('status','false')->orderBy('id', 'DESC')->paginate(20);
        }
        $users = User::where('role','affiliate')->where('status','active')->get();
        $offers = Offer::where('status','requestApproved')->get();
        return view('admin.offer.application',compact('applications','users','offers'));
    }
    public function approved($id)
    {
        $application = OfferApplication::find($id);
        $application->update([
            'status' => true
        ]);
        $user = User::find($application->user_id);
        Notification::send($user , new OfferApplicationApproved($application));
        return back()->with('success','Offer Application Approved Successfully');
    }
}
