<?php

namespace App\Http\Controllers\Admin;

use App\CountryPayout;
use App\Optimize;
use App\CoustomCap;
use App\CoustomCountryDevicePayout;
use App\CoustomCountryPayout;
use App\CoustomPayout;
use App\Device;
use App\DevicePayout;
use App\Http\Controllers\Controller;
use App\Offer;
use App\User;
use Illuminate\Http\Request;

class PayoutController extends Controller
{
    public function index($id)
    {
        $offer = Offer::find($id);
        return view('admin.payout.index', compact('offer'));
    }

    public function countryPayouts($id)
    {
        $offer = Offer::find($id);
        return view('admin.payout.country', compact('offer'));
    }

    public function countryPayoutsStore(Request $request,$id)
    {

        $this->validate($request, [
            'country_id' => 'required',
            'revenue' => 'required',
            'payout' => 'required',
        ]);
        $countryPayout = CountryPayout::where('offer_id', $id)->where('country_id', $request->country_id)->first();
        if ($countryPayout) {
            $countryPayout->update([
                'revenue' => $request->revenue,
                'payout' => $request->payout,
            ]);
        } else {
            CountryPayout::create([
                'offer_id' => $id,
                'country_id' => $request->country_id,
                'revenue' => $request->revenue,
                'payout' => $request->payout,
            ]);
        }
        return back()->with('success', 'Payout added successfully');
    }

    public function countryPayoutsDelete($id)
    {
        CountryPayout::find($id)->delete();
        return back()->with('success', 'Payout deleted successfully');
    }

    public function devicePayouts($id)
    {
        $offer = Offer::find($id);
        $device = Device::all();
        return view('admin.payout.device', compact('offer', 'device'));
    }

    public function devicePayoutsStore(Request $request,$id)
    {
        $this->validate($request, [
            'device_id' => 'required',
            'revenue' => 'required',
            'payout' => 'required',
        ]);
        $devicePayout = DevicePayout::where('country_payout_id', $request->country_payout_id)->where('device_id', $request->device_id)->first();
        if ($devicePayout) {
            $devicePayout->update([
                'revenue' => $request->revenue,
                'payout' => $request->payout,
            ]);
        } else {
            DevicePayout::create([
                'country_payout_id' => $request->country_payout_id,
                'device_id' => $request->device_id,
                'revenue' => $request->revenue,
                'payout' => $request->payout,
            ]);
        }
        return back()->with('success', 'Payout added successfully');
    }

    public function devicePayoutsDelete($id)
    {
        DevicePayout::find($id)->delete();
        return back()->with('success', 'Payout deleted successfully');
    }

    public function coustomPayouts($id)
    {
        $offer = Offer::find($id);
        $affiliates = User::where('role','affiliate')->get();
        return view('admin.payout.coustomPayout', compact('offer','affiliates'));
    }

    public function coustomPayoutsStore(Request $request,$id)
    {
        $this->validate($request, [
            'affiliate_id' => 'required',
            'revenue' => 'required',
            'payout' => 'required',
        ]);
        $coustomPayout = CoustomPayout::where('offer_id', $id)->where('user_id', $request->affiliate_id)->first();
        if ($coustomPayout) {
            $coustomPayout->update([
                'revenue' => $request->revenue,
                'payout' => $request->payout,
            ]);
        } else {
            CoustomPayout::create([
                'offer_id' => $id,
                'user_id' => $request->affiliate_id,
                'revenue' => $request->revenue,
                'payout' => $request->payout,
            ]);
        }
        return back()->with('success', 'Payout added successfully');
    }

    public function coustomPayoutsDelete($id)
    {
        CoustomPayout::findOrFail($id)->delete();
        return back()->with('success', 'Payout deleted successfully');
    }

    public function coustomCap($id)
    {
        $offer = Offer::find($id);
        $affiliates = User::where('role','affiliate')->get();
        return view('admin.payout.cap', compact('offer','affiliates'));
    }

    public function coustomCapStore(Request $request,$id)
    {
        $this->validate($request, [
            'affiliate_id' => 'required',
            'cap' => 'required',
        ]);
        $cap = CoustomCap::where('offer_id', $id)->where('user_id', $request->affiliate_id)->first();
        if ($cap) {
            $cap->update([
                'cap' => $request->cap,
            ]);
        } else {
            CoustomCap::create([
                'offer_id' => $id,
                'user_id' => $request->affiliate_id,
                'cap' => $request->cap,
            ]);
        }
        return back()->with('success', 'Cap added successfully');
    }

    public function coustomCapDelete($id)
    {
        CoustomCap::find($id)->delete();
        return back()->with('success', 'Cap deleted successfully');
    }

    public function coustomCountryPayouts($id)
    {
        $offer = Offer::find($id);
        $affiliates = User::where('role','affiliate')->get();
        return view('admin.payout.coustomCountry', compact('offer','affiliates'));
    }

    public function coustomCountryPayoutsStore(Request $request,$id)
    {
        $this->validate($request, [
            'user_id' => 'required',
            'country_id' => 'required',
            'revenue' => 'required',
            'payout' => 'required',
        ]);
        $coustomCountryPayout = CoustomCountryPayout::where('offer_id', $id)->where('user_id', $request->user_id)->where('country_id', $request->country_id)->first();
        if ($coustomCountryPayout) {
            $coustomCountryPayout->update([
                'revenue' => $request->revenue,
                'payout' => $request->payout,
            ]);
        } else {
            CoustomCountryPayout::create([
                'offer_id' => $id,
                'user_id' => $request->user_id,
                'country_id' => $request->country_id,
                'revenue' => $request->revenue,
                'payout' => $request->payout,
            ]);
        }
        return back()->with('success', 'Payout added successfully');
    }

    public function coustomCountryPayoutsDelete($id)
    {
        CoustomCountryPayout::find($id)->delete();
        return back()->with('success', 'Payout deleted successfully');
    }

    public function coustomDevicePayouts($id)
    {
        $offer = Offer::find($id);
        $user_id = CoustomCountryPayout::where('offer_id', $id)->distinct()->pluck('user_id');
        $affiliates = User::findMany($user_id);
        return view('admin.payout.coustomDevice', compact('offer','affiliates'));
    }

    public function getCountryData(Request $request)
    {
        $id = $request->offer_id;
        $user_id = $request->user_id;
        $user = User::find($user_id);
        $countries = $user->coustomCountryPayouts()->where('offer_id',$id)->with('country')->get();
        return response()->json($countries);
    }

    public function coustomDevicePayoutsStore(Request $request)
    {
        $this->validate($request, [
            'country_payout_id' => 'required',
            'device_id' => 'required',
            'revenue' => 'required',
            'payout' => 'required',
        ]);
        $coustomDevicePayout = CoustomCountryDevicePayout::where('coustom_country_payout_id', $request->country_payout_id)
            ->where('device_id', $request->device_id)
            ->first();
        if ($coustomDevicePayout)
        {
            $coustomDevicePayout->update([
                'revenue' => $request->revenue,
                'payout' => $request->payout,
            ]);
        }
        else
        {
            CoustomCountryDevicePayout::create([
                'coustom_country_payout_id' => $request->country_payout_id,
                'device_id' => $request->device_id,
                'revenue' => $request->revenue,
                'payout' => $request->payout,
            ]);
        }
        return back()->with('success', 'Payout added successfully');

    }

    public function coustomDevicePayoutsDelete($id)
    {
        CoustomCountryDevicePayout::find($id)->delete();
        return back()->with('success', 'Payout deleted successfully');
    }
     public function optimizeStore(Request $request)
    {
        $this->validate($request,[
            'offer_id' => 'required|exists:offers,id',
            'percentage' => 'required',
        ]);
        // Check exits or not
        $optimize = Optimize::where('offer_id', $request->offer_id)->first();
        if ($optimize) {
            $optimize->update([
                'percentage' => $request->percentage,
            ]);
        } else {
            Optimize::create([
                'offer_id' => $request->offer_id,
                'percentage' => $request->percentage,
            ]);
        }
        return back()->with('success', 'Optimize added successfully');
    }

    public function optimizeDelete($id)
    {
        Optimize::findOrFail($id)->delete();
        return back()->with('success', 'Optimize deleted successfully');
    }
}
