<?php

namespace App\Http\Controllers\Admin;

use App\Advertiser;
use App\Country;
use App\Offer;
use App\PostbackLog;
use App\Report;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class ReportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function day(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = [];
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }

        $total = Report::total($advertiser_id,$date_from,$date_to, $offer_id, $country_id, $user_id);

        $period = \Carbon\CarbonPeriod::create($date_from, $date_to);
        $reports = [];

        foreach ($period as $date) {

            // Base query for all aggregations
            $baseQuery = function() use ($date, $offer_id, $user_id, $country_id, $advertiser_id) {
                return Report::where('date', $date->toDateString())
                    ->when(!empty($offer_id), function ($q) use ($offer_id) {
                        return $q->whereIn('offer_id', $offer_id);
                    })
                    ->when(!empty($user_id), function ($q) use ($user_id) {
                        return $q->whereIn('user_id', $user_id);
                    })
                    ->when(!empty($country_id), function ($q) use ($country_id) {
                        return $q->whereIn('country_id', $country_id);
                    })
                    ->when(!empty($advertiser_id), function ($q) use ($advertiser_id) {
                        return $q->whereHas('offer', function ($q) use ($advertiser_id) {
                            $q->whereIn('advertiser_id', $advertiser_id);
                        });
                    });
            };

            // Get clicks and uniques from the base query
            $click = (clone $baseQuery())->sum('click');
            $unique = (clone $baseQuery())->sum('unique');
            
            // For approved status metrics, we need to add the status condition
            $approvedQuery = function() use ($baseQuery) {
                return $baseQuery()->where('status', 'approved');
            };
            
            $conversion = (clone $approvedQuery())->count();
            $revenue = (clone $approvedQuery())->sum('revenue');
            $payout = (clone $approvedQuery())->sum('payout');
            $profit = (clone $approvedQuery())->sum('profit');
            $reports[$date->toDateString()] = compact('click', 'unique', 'conversion', 'revenue', 'payout', 'profit');
        }
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('admin.report.day', compact('countries','users','offers','advertisers','reports','total'));
    }

    public function offer(Request $request)
    {
        $offer_id = Report::query()->pluck('offer_id')->unique()->toArray();
        $offers = $offer_id;
        $country_id = [];
        $user_id = [];
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }

        $total = Report::total($advertiser_id,$date_from,$date_to, $offer_id, $country_id, $user_id);

        // Initialize reports array
        $reports = [];

        foreach ($offers as $offer_id) {
            $query = Report::where('offer_id', $offer_id)
                ->whereBetween('date', [$date_from, $date_to])
                ->when(!empty($user_id), function ($query) use ($user_id) {
                    return $query->whereIn('user_id', $user_id);
                })
                ->when(!empty($country_id), function ($query) use ($country_id) {
                    return $query->whereIn('country_id', $country_id);
                })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                    return $query->whereHas('offer', function ($query) use ($advertiser_id) {
                        $query->whereIn('advertiser_id', $advertiser_id);
                    });
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $revenue = $query->where('status','approved')->sum('revenue');
            $payout = $query->where('status','approved')->sum('payout');
            $profit = $query->where('status','approved')->sum('profit');
            $reports[$offer_id] = compact('click', 'unique', 'conversion', 'revenue', 'payout', 'profit');
        }
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('admin.report.offer', compact('countries','users','offers','advertisers','reports','total'));
    }
      public function affiliate(Request $request)
    {
        $offer_id = [];
        $offers = $offer_id;
        $country_id = [];
        $user_id = User::where('role','affiliate')->pluck('id')->toArray();
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }

        $total = Report::total($advertiser_id,$date_from,$date_to, $offer_id, $country_id, $user_id);

        $users = $user_id ?? User::where('role','affiliate')->pluck('id')->toArray();
        foreach ($users as $user_id) {
            $query = Report::where('user_id', $user_id)
                ->whereBetween('date', [$date_from, $date_to])
                ->when(!empty($offer_id), function ($query) use ($offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                })
                ->when(!empty($country_id), function ($query) use ($country_id) {
                    return $query->whereIn('country_id', $country_id);
                })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                    return $query->whereHas('offer', function ($query) use ($advertiser_id) {
                        $query->whereIn('advertiser_id', $advertiser_id);
                    });
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $revenue = $query->where('status','approved')->sum('revenue');
            $payout = $query->where('status','approved')->sum('payout');
            $profit = $query->where('status','approved')->sum('profit');
            $reports[$user_id] = compact('click', 'unique', 'conversion', 'revenue', 'payout', 'profit');
        }
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('admin.report.affiliate', compact('countries','users','offers','advertisers','reports','total'));
    }
    public function country(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = [];
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }

        $total = Report::total($advertiser_id,$date_from,$date_to, $offer_id, $country_id, $user_id);
        $countries = $request->country_id ?? Report::query()->distinct()->pluck('country_id');
        $reports = [];
        foreach ($countries as $country_id) {
            $query = Report::where('country_id',$country_id)
                ->whereBetween('date', [$date_from, $date_to])
                ->when(!empty($user_id), function ($query) use ($user_id) {
                    return $query->whereIn('user_id', $user_id);
                })->when(!empty($offer_id), function ($query) use ($offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                })
                ->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                    return $query->whereHas('offer', function ($query) use ($advertiser_id) {
                        $query->whereIn('advertiser_id', $advertiser_id);
                    });
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $revenue = $query->where('status','approved')->sum('revenue');
            $payout = $query->where('status','approved')->sum('payout');
            $profit = $query->where('status','approved')->sum('profit');
            $reports[$country_id] = compact('click', 'unique', 'conversion', 'revenue', 'payout', 'profit');
        }
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('admin.report.country', compact('countries','users','offers','advertisers','reports','total'));
    }

    public function aff_sub_1(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = [];
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $total = Report::total($advertiser_id,$date_from,$date_to, $offer_id, $country_id, $user_id);
        $aff_sub_1 = Report::query()->distinct()->pluck('aff_sub_1')->toArray();
        $reports = [];
        foreach ($aff_sub_1 as $aff_sub_1) {
            $query = Report::where('aff_sub_1',$aff_sub_1)
                ->whereBetween('date', [$date_from, $date_to])
                ->when(!empty($user_id), function ($query) use ($user_id) {
                    return $query->whereIn('user_id', $user_id);
                })->when(!empty($offer_id), function ($query) use ($offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                    return $query->whereHas('offer', function ($query) use ($advertiser_id) {
                        $query->whereIn('advertiser_id', $advertiser_id);
                    });
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $revenue = $query->where('status','approved')->sum('revenue');
            $payout = $query->where('status','approved')->sum('payout');
            $profit = $query->where('status','approved')->sum('profit');
            $reports[$aff_sub_1] = compact('click', 'unique', 'conversion', 'revenue', 'payout', 'profit');
        }
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('admin.report.aff_sub_1', compact('countries','users','offers','advertisers','reports','total'));

    }
    public function aff_sub_2(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = [];
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $total = Report::total($advertiser_id,$date_from,$date_to, $offer_id, $country_id, $user_id);
        $aff_sub_2 = Report::query()->distinct()->pluck('aff_sub_2')->toArray();
        $reports = [];
        foreach ($aff_sub_2 as $aff_sub_2) {
            $query = Report::where('aff_sub_2',$aff_sub_2)
                ->whereBetween('date', [$date_from, $date_to])
                ->when(!empty($user_id), function ($query) use ($user_id) {
                    return $query->whereIn('user_id', $user_id);
                })->when(!empty($offer_id), function ($query) use ($offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                    return $query->whereHas('offer', function ($query) use ($advertiser_id) {
                        $query->whereIn('advertiser_id', $advertiser_id);
                    });
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $revenue = $query->where('status','approved')->sum('revenue');
            $payout = $query->where('status','approved')->sum('payout');
            $profit = $query->where('status','approved')->sum('profit');
            $reports[$aff_sub_2] = compact('click', 'unique', 'conversion', 'revenue', 'payout', 'profit');
        }
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('admin.report.aff_sub_2', compact('countries','users','offers','advertisers','reports','total'));

    }
    public function aff_sub_3(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = [];
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $total = Report::total($advertiser_id,$date_from,$date_to, $offer_id, $country_id, $user_id);
        $aff_sub_3 = Report::query()->distinct()->pluck('aff_sub_3')->toArray();
        $reports = [];
        foreach ($aff_sub_3 as $aff_sub_3) {
            $query = Report::where('aff_sub_3',$aff_sub_3)
                ->whereBetween('date', [$date_from, $date_to])
                ->when(!empty($user_id), function ($query) use ($user_id) {
                    return $query->whereIn('user_id', $user_id);
                })->when(!empty($offer_id), function ($query) use ($offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                    return $query->whereHas('offer', function ($query) use ($advertiser_id) {
                        $query->whereIn('advertiser_id', $advertiser_id);
                    });
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $revenue = $query->where('status','approved')->sum('revenue');
            $payout = $query->where('status','approved')->sum('payout');
            $profit = $query->where('status','approved')->sum('profit');
            $reports[$aff_sub_3] = compact('click', 'unique', 'conversion', 'revenue', 'payout', 'profit');
        }
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('admin.report.aff_sub_3', compact('countries','users','offers','advertisers','reports','total'));

    }

    public function click(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = [];
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $query = Report::whereBetween('date',[$date_from,$date_to])
            ->where('status','click')
            ->when(!empty($user_id), function ($query) use ($user_id) {
                return $query->whereIn('user_id', $user_id);
            })->when(!empty($offer_id), function ($query) use ($offer_id) {
                return $query->whereIn('offer_id', $offer_id);
            })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                return $query->whereHas('offer', function ($query) use ($advertiser_id) {
                    $query->whereIn('advertiser_id', $advertiser_id);
                });
            })->when(!empty($country_id), function ($query) use ($country_id) {
                return $query->whereIn('country_id', $country_id);
            });
        $clicks = $query->orderBy('id','desc')->paginate(30);
        $total = $query->count();
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
       return view('admin.report.click', compact('countries','users','offers','advertisers','clicks','total'));
    }

    public function convert($id)
    {
        $report = Report::find($id);
        if ($report->offer->type == "smartlink") {
            return back()->with('error', 'This offer is not convertable Because it is smartlink');
        }
        $profit = $report->revenue - $report->payout;
        $report->update([
            'status' => 'approved',
            'profit' => $profit,
            'date' => Carbon::now()->toDateString(),
        ]);
        // Increment User Balance
        $user = User::find($report->user_id);
        $user->increment('balance', $report->payout);

        if($user->refer_id !=null){
            commissionAdd($report->payout,$user->refer_id,$user->id);
        }

        // Increment manager balance

        $manager = User::find($user->manager_id);
        if ($manager && $manager->comission) {
            $manager_profit = $report->payout * $manager->comission / 100;
            $manager->increment('balance', $manager_profit);
        }
        return redirect()->back()->with('success', 'Report has been approved');

    }

    public function conversion(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = [];
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $query = Report::whereBetween('date',[$date_from,$date_to])
            ->where('status','approved')
            ->when(!empty($user_id), function ($query) use ($user_id) {
                return $query->whereIn('user_id', $user_id);
            })->when(!empty($offer_id), function ($query) use ($offer_id) {
                return $query->whereIn('offer_id', $offer_id);
            })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                return $query->whereHas('offer', function ($advertiser_id) use ($query) {
                    $query->where('advertiser_id', $advertiser_id);
                });
            })->when(!empty($country_id), function ($query) use ($country_id) {
                return $query->whereIn('country_id', $country_id);
            })->orderBy('id','desc');
        $conversions = $query->paginate(30);
        $total = $query->count();
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('admin.report.conversion', compact('countries','users','offers','advertisers','conversions','total'));
    }

    public function reject($id)
    {
        $report = Report::find($id);
        $report->update([
            'status' => 'rejected',
        ]);
        // Decrement  User Balance
        $user = User::find($report->user_id);
        $user->decrement('balance', $report->payout);

        if($user->refer_id !=null){
            decreaseReferCommission($report->payout,$user->refer_id,$user->id);
        }

        // Decrement manager balance

        $manager = User::find($user->manager_id);
        if ($manager && $manager->comission) {
            $manager_profit = $report->payout * $manager->comission / 100;
            $manager->decrement('balance', $manager_profit);
        }
        return redirect()->back()->with('success', 'Conversion has been rejected');
    }

    public function rejected(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = [];
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $query = Report::whereBetween('date',[$date_from,$date_to])
            ->where('status','rejected')
            ->when(!empty($user_id), function ($query) use ($user_id) {
                return $query->whereIn('user_id', $user_id);
            })->when(!empty($offer_id), function ($query) use ($offer_id) {
                return $query->whereIn('offer_id', $offer_id);
            })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                return $query->whereHas('offer', function ($advertiser_id) use ($query) {
                    $query->where('advertiser_id', $advertiser_id);
                });
            })->when(!empty($country_id), function ($query) use ($country_id) {
                return $query->whereIn('country_id', $country_id);
            });
        $conversions = $query->paginate(30);
        $total = $query->count();
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('admin.report.rejected', compact('countries','users','offers','advertisers','conversions','total'));
    }

    public function pending(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = [];
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $query = Report::whereBetween('date',[$date_from,$date_to])
            ->where('status','pending')
            ->when(!empty($user_id), function ($query) use ($user_id) {
                return $query->whereIn('user_id', $user_id);
            })->when(!empty($offer_id), function ($query) use ($offer_id) {
                return $query->whereIn('offer_id', $offer_id);
            })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                return $query->whereHas('offer', function ($advertiser_id) use ($query) {
                    $query->where('advertiser_id', $advertiser_id);
                });
            })->when(!empty($country_id), function ($query) use ($country_id) {
                return $query->whereIn('country_id', $country_id);
            });
        $conversions = $query->paginate(30);
        $total = $query->count();
        $countries = Country::all();
        $users = User::where('role','affiliate')->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('admin.report.rejected', compact('countries','users','offers','advertisers','conversions','total'));
    }

    public function postback_log(Request $request)
    {
       $user_id = [];
       $offer_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }

       $postbacks = PostbackLog::where('date', '>=', $date_from)
           ->where('date', '<=', $date_to)
       ->when($offer_id, function ($query, $offer_id) {
           $query->where('offer_id',$offer_id );
       })->when($user_id, function ($query, $user_id) {
           $query->where('user_id',$user_id );
       })->orderBy('id','desc')->paginate(30);
       $offers = Offer::where('status','active')->get();
       $users = User::where('role','affiliate')->get();
       return view('admin.report.postback-log', compact('postbacks','offers','users'));
    }


}
