<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\GeneralSetting;
use App\Http\Requests\MailUpdate;
use App\Question;
use App\Setting;
use Artisan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Config;


class SettingController extends Controller
{
    public function general()
    {
        $timezones = timezone_identifiers_list();
        return view('admin.settings.general',compact('timezones'));
    }

    public function generalUpdate(GeneralSetting $request)
    {
        Setting::updateOrCreate(['name' => 'site_title'], ['value' => $request->site_title]);
        Artisan::call('dotenv:set-key', ['key' => 'APP_NAME', 'value' => $request->get('site_title')]);
       
        Setting::updateOrCreate(['name' => 'site_time_zone'],['value' => $request->get('site_time_zone')]);
        Artisan::call('dotenv:set-key', ['key' => 'APP_TIMEZONE', 'value' => $request->get('site_time_zone')]);
        $newTimezone = $request->get('site_time_zone');
    
        $appConfigPath = config_path('app.php');
        $config = file_get_contents($appConfigPath);
        
        // Replace the existing timezone value with the new timezone
        $config = preg_replace("/'timezone' => '.+'/", "'timezone' => '$newTimezone'", $config);

        // Write the modified content back to the file
        file_put_contents($appConfigPath, $config);

        // Clear the configuration cache (optional)
        Artisan::call('config:clear');

        Setting::updateOrCreate(['name' => 'tracking_domain'],['value' => $request->get('tracking_domain')]);
        Setting::updateOrCreate(['name' => 'traffic_back'],['value' => $request->get('traffic_back')]);
        Setting::updateOrCreate(['name' => 'affiliate_register'],['value' => $request->get('affiliate_register')]);
        Setting::updateOrCreate(['name' => 'affiliate_register_status'],['value' => $request->get('affiliate_register_status')]);
        Setting::updateOrCreate(['name' => 'site_conversion_status'],['value' => $request->get('site_conversion_status')]);
        Setting::updateOrCreate(['name' => 'refer_commission'],['value' => $request->get('refer_commission')]);
        Setting::updateOrCreate(['name' => 'copyright_text'],['value' => $request->get('copyright_text')]);
        Setting::updateOrCreate(['name' => 'minimum_invoice'],['value' => $request->get('minimum_invoice')??0]);
        Setting::updateOrCreate(['name' => 'invoice_schedule'],['value' => $request->get('invoice_schedule')]);
        Setting::updateOrCreate(['name' => 'fraud_detect'],['value' => $request->get('fraud_detect')]);
        Setting::updateOrCreate(['name' => 'auto_invoice'],['value' => $request->get('auto_invoice')]);
        Setting::updateOrCreate(['name' => 'scroll_text'],['value' => $request->get('scroll_text')]);
        Setting::updateOrCreate(['name' => 'ip_score_api_key'],['value' => $request->get('ip_score_api_key')]);
        return redirect()->back()->with('success', 'General Settings Updated Successfully');
    }

    public function appearance()
    {
        return view('admin.settings.appearance');
    }

    public function appearanceUpdate(Request $request)
    {
        $this->validate($request,[
            'site_logo_light' => 'nullable|mimes:jpeg,jpg,png,gif,svg|max:10240',
            'site_logo_dark' => 'nullable|mimes:jpeg,jpg,png,gif,svg|max:10240',
            'site_logo_small_light' => 'nullable|mimes:jpeg,jpg,png,gif,svg|max:10240',
            'site_logo_small_dark' => 'nullable|mimes:jpeg,jpg,png,gif,svg|max:10240',
            'site_favicon' => 'nullable|mimes:jpeg,jpg,png,gif,svg,ico|max:10240',
        ]);

        //Upload Light Theme Logo
        if($request->hasFile('site_logo_light')){
            $this->deleteOldLogo(setting('site_logo_light'));
            $logoPath = Storage::disk('public')->putFile('logos', $request->file('site_logo_light'));
            Setting::updateOrCreate(
                ['name' => 'site_logo_light'],
                ['value' => $logoPath]
            );
        }
        
        //Upload Dark Theme Logo
        if($request->hasFile('site_logo_dark')){
            $this->deleteOldLogo(setting('site_logo_dark'));
            $logoPath = Storage::disk('public')->putFile('logos', $request->file('site_logo_dark'));
            Setting::updateOrCreate(
                ['name' => 'site_logo_dark'],
                ['value' => $logoPath]
            );
        }
        
        //Upload Light Theme Small Logo
        if($request->hasFile('site_logo_small_light')){
            $this->deleteOldLogo(setting('site_logo_small_light'));
            $smallLogoPath = Storage::disk('public')->putFile('logos', $request->file('site_logo_small_light'));
            Setting::updateOrCreate(
                ['name' => 'site_logo_small_light'],
                ['value' => $smallLogoPath]
            );
        }
        
        //Upload Dark Theme Small Logo
        if($request->hasFile('site_logo_small_dark')){
            $this->deleteOldLogo(setting('site_logo_small_dark'));
            $smallLogoPath = Storage::disk('public')->putFile('logos', $request->file('site_logo_small_dark'));
            Setting::updateOrCreate(
                ['name' => 'site_logo_small_dark'],
                ['value' => $smallLogoPath]
            );
        }
        
        //Upload Favicon
        if($request->hasFile('site_favicon')){
            $this->deleteOldLogo(setting('site_favicon'));
            $faviconPath = Storage::disk('public')->putFile('logos', $request->file('site_favicon'));
            Setting::updateOrCreate(
                ['name' => 'site_favicon'],
                ['value' => $faviconPath]
            );
        }
        
        // Update Theme
        Setting::updateOrCreate(['name' => 'site_theme'], ['value' => $request->site_theme]);

        return back()->with('success', 'Appearance Settings Updated Successfully');
    }
    private function deleteOldLogo($path)
    {
        if ($path && Storage::disk('public')->exists($path)) {
            Storage::disk('public')->delete($path);
        }
    }

    public function deleteLogo($type)
    {
        $allowedTypes = ['site_logo_light', 'site_logo_dark', 'site_logo_small_light', 'site_logo_small_dark', 'site_favicon'];
        
        if (!in_array($type, $allowedTypes)) {
            return back()->with('error', 'Invalid logo type');
        }

        $this->deleteOldLogo(setting($type));
        Setting::where('name', $type)->delete();

        return back()->with('success', ucfirst(str_replace('_', ' ', $type)) . ' deleted successfully');
    }

    public function mail()
    {
        return view('admin.settings.mail');
    }

    public function mailUpdate(MailUpdate $request)
    {
        Setting::updateOrCreate(['name' => 'mail_driver'],['value' => $request->get('mail_driver')]);
        Artisan::call('dotenv:set-key', ['key' => 'MAIL_DRIVER', 'value' => $request->get('mail_driver')]);

        Setting::updateOrCreate(['name' => 'mail_host'],['value' => $request->get('mail_host')]);
        Artisan::call('dotenv:set-key', ['key' => 'MAIL_HOST', 'value' => $request->get('mail_host')]);

        Setting::updateOrCreate(['name' => 'mail_port'],['value' => $request->get('mail_port')]);
        Artisan::call('dotenv:set-key', ['key' => 'MAIL_PORT', 'value' => $request->get('mail_port')]);

        Setting::updateOrCreate(['name' => 'mail_username'],['value' => $request->get('mail_username')]);
        Artisan::call('dotenv:set-key', ['key' => 'MAIL_USERNAME', 'value' => $request->get('mail_username')]);

        Setting::updateOrCreate(['name' => 'mail_password'],['value' => $request->get('mail_password')]);
        Artisan::call('dotenv:set-key', ['key' => 'MAIL_PASSWORD', 'value' => $request->get('mail_password')]);

        Setting::updateOrCreate(['name' => 'mail_encryption'],['value' => $request->get('mail_encryption')]);
        Artisan::call('dotenv:set-key', ['key' => 'MAIL_ENCRYPTION', 'value' => $request->get('mail_encryption')]);


        Setting::updateOrCreate(['name' => 'mail_from_address'],['value' => $request->get('mail_from_address')]);
        Artisan::call('dotenv:set-key', ['key' => 'MAIL_FROM_ADDRESS', 'value' => $request->get('mail_from_address')]);

       
        return back()->with('success', 'Mail Settings Updated Successfully');
    }

    public function registerQuestion()
    {
        $questions = Question::all();
        return view('admin.settings.question',compact('questions'));
    }

    public function registerQuestionStore(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|string|max:255',
            'placeholder' => 'required|string|max:255',
        ]);
        Question::create([
            'name' => $request->name,
            'placeholder' => $request->placeholder,
            'required' => $request->status,
        ]);
        return back()->with('success', 'Question Added Successfully');
    }

    public function questionDelete($id)
    {
        Question::findOrFail($id)->delete();
        return back()->with('success', 'Question Deleted Successfully');
    }
}



