<?php
namespace App\Http\Controllers\Auth;

use App\Answer;
use App\Question;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Auth\Events\Registered;

class RegisterController extends Controller
{
    use RegistersUsers;

    protected $redirectTo; // Redirect to the verification notice page

    public function __construct()
    {
        $this->middleware('guest');
    }

    protected function validator(array $data)
    {
        return Validator::make($data, [
            'first_name' => ['required', 'string', 'max:255'],
            'last_name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
            'country_id' => ['required', 'integer'],
            'skype' => ['required', 'string', 'max:255'],
        ]);
    }

    protected function create(array $data)
    {
        $refer_id = request('refer_id');

        $user = User::create([
            'first_name' => $data['first_name'],
            'last_name' => $data['last_name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
            'refer_id' => $refer_id,
            'country_id' => $data['country_id'],
            'skype' => $data['skype'],
        ]);

        if (Question::count() != 0) {
            $questions = Question::orderBy('id', 'asc')->get();
            foreach ($questions as $question) {
                Answer::create([
                    'user_id' => $user->id,
                    'question_id' => $question->id,
                    'answer' => $data[$question->id] ?? null, // Ensure a default value if not provided
                ]);
            }
        }

        $user->sendEmailVerificationNotification(); // Send the verification email
        return $user;
    }

    public function register(Request $request)
    {
        $this->validator($request->all())->validate();

        event(new Registered($user = $this->create($request->all())));

        // Redirect with a custom message
        return redirect()->route('login')->with('success', 'Registration successful! Please check your email (spam folder also) to verify your account.');
    }
}
