<?php

namespace App\Http\Controllers\Manager;

use App\Country;
use App\Finance;
use App\PaymentMethod;
use App\Http\Controllers\Controller;
use App\Http\Requests\AffiliateProfileUpdate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AccountController extends Controller
{
    public function index()
    {
        $countries = Country::all();
        $finances = Finance::all();
        return view('manager.account.index',compact('countries','finances'));
    }

    public function update(AffiliateProfileUpdate $request)
    {
        $user = Auth::user();
        $user->update([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'country_id' => $request->country_id,
            'skype' => $request->skype,
        ]);
        if ($request->hasFile('avater')) {
            $user->addMedia($request->avater)->toMediaCollection('avater');
        }
        if ($request->password) {
            $this->validate($request, [
                'password' => 'required|min:6|confirmed',
            ]);
            $password = $user->password;
            if (\Hash::check($request->old_password , $password )) {
                if (!\Hash::check($request->password , $password)) {
                    $user = Auth::user();
                    $user->update([
                        'password' => Hash::make($request->password),
                    ]);
                    return back()->with('success', 'Password changed successfully');
                }
                else{
                    return back()->with('error', 'New password can not be same as old password');
                }

            }

            else{
                return back()->with('error', 'Old password is incorrect');
            }
        }
        if ($request->hasFile('avatar')) {
            $user->addMedia($request->avater)->toMediaCollection('avater');
        }
        return back()->with('success', 'Profile updated successfully');
    }
    
    public function paymentUpdate(Request $request)
    {
        $this->validate($request,[
            'finance_id' => 'required',
            'wallet' => 'required|string',
        ]);
        $paymentMethod = PaymentMethod::where('user_id',Auth::user()->id)->first();
        if ($paymentMethod) {
            $paymentMethod->update([
                'finance_id' => $request->finance_id,
                'wallet' => $request->wallet,
            ]);
        }
        else{
            PaymentMethod::create([
                'user_id' => Auth::user()->id,
                'finance_id' => $request->finance_id,
                'wallet' => $request->wallet,
            ]);
        }
        return back()->with('success', 'Payment method update successfully');
    }
}
