<?php

namespace App\Http\Controllers\Manager;

use App\User;
use App\Offer;
use App\Country;
use Illuminate\Http\Request;
use App\Notifications\OfferBlocked;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\RegisterRequest;
use App\Notifications\AffiliateActive;
use App\Notifications\AffiliateSuspend;
use App\Http\Requests\UserUpdateRequest;
use App\Notifications\AffiliateApproved;
use App\Notifications\AdminAffiliateCreate;
use Illuminate\Support\Facades\Notification;

class AffiliateController extends Controller
{
    public function index(Request $request)
    {
        $id = User::where('manager_id', Auth::user()->id)->pluck('id')->toArray();
        $name = '';
        $email = '';
        $country_id = [];
        $status = '';
        $manager_id = '';
        if ($request->filter) {
            $id = request()->get('id');
            // Check User ID Own Or Not
            $name = request()->get('name');
            $email = request()->get('email');
            $country_id = request()->get('country_id');
            $status = request()->get('status');
            $manager_id = request()->get('manager_id');
            $affiliates = User::where('role','affiliate')
                ->when($status, function ($query) use ($status) {
                    return $query->where('status', $status);
                })
                ->when($id, function ($query) use ($id) {
                    return $query->where('id', $id);
                })->when($name, function ($query) use ($name) {
                    return $query->where('first_name', 'like', '%' . $name . '%')->orWhere('last_name', 'like', '%' . $name . '%');
                })->when($email, function ($query) use ($email) {
                    return $query->where('email', 'like', '%' . $email . '%');
                })->when($country_id, function ($query) use ($country_id) {
                    return $query->whereIn('country_id', $country_id);
                })->when($manager_id, function ($query) use ($manager_id) {
                    return $query->whereIn('manager_id', $manager_id);
                })->paginate(20);
        }else{
            $affiliates = User::whereIn('id',$id)->where('role','affiliate')->paginate(20);
        }
        $countries = Country::all();
        return view('manager.affiliate.index',compact('countries','affiliates'));
    }
    public function create()
    {
        $countries = Country::all();
        return view('manager.affiliate.form',compact('countries'));
    }

    public function store(RegisterRequest $request)
    {
        $affiliate = User::create([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'country_id' => $request->country_id,
            'skype' => $request->skype,
            'manager_id' => Auth::id(),
            'status' => $request->status,
            'password' => bcrypt($request->password),
        ]);

        if($request->hasFile('avater'))
        {
            $affiliate->addMedia($request->avater)->toMediaCollection('avatar');
        }
        Notification::send($affiliate, new AdminAffiliateCreate($affiliate));

        return redirect()->route('manager.affiliate.index');
    }

    public function edit($id)
    {
        $affiliate = User::findOrFail($id);
        $countries = Country::all();
        return view('manager.affiliate.form',compact('affiliate','countries'));
    }

    public function update(UserUpdateRequest $request,$id)
    {

        $affiliate = User::findOrFail($id);

        // Affiliate Approved Mail
        if ($affiliate->status == 'pending' && $request->status == 'active') {
            Notification::send($affiliate, new AffiliateApproved($affiliate));
        }
        // Affiliate Suspend Mail
        if ($affiliate->status == 'active' && $request->status == 'suspend') {
            Notification::send($affiliate, new AffiliateSuspend($affiliate));
        }
        // Affiliate Suspend To Approved
        if ($affiliate->status == 'suspend' && $request->status == 'active') {
            Notification::send($affiliate, new AffiliateActive($affiliate));
        }

        $affiliate->update([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'country_id' => $request->country_id,
            'skype' => $request->skype,
            'manager_id' => Auth::id(),
            'status' => $request->status,
        ]);
        if ($request->password) {
            $this->validate($request, [
                'password' => 'required|min:6|confirmed',
            ]);
            $affiliate->update([
                'password' => bcrypt($request->password),
            ]);
        }
        if($request->hasFile('avater'))
        {
            $affiliate->addMedia($request->avater)->toMediaCollection('avatar');
        }
        return redirect()->route('manager.affiliate.index');
    }

    public function delete($id)
    {
        User::findOrFail($id)->delete();
        return back();
    }

    public function show($id)
    {
        $affiliate = User::findOrFail($id);
        $offers = Offer::where('status','active')->orWhere('status','requestApproved')->get();
        return view('manager.affiliate.show',compact('affiliate','offers'));
    }
    public function blocked(Request $request,$id)
    {
        $user = User::find($id);
        if($user->offers)
        {
            $sync = $user->offers()->sync($request->offer_id);

            if ($sync) {
                foreach ($sync as $id)
                {
                    $offers = Offer::findMany($id);
                    foreach ($offers as $offer)
                    {
                        Notification::send($user , new OfferBlocked($offer));
                    }

                }
            }
        }
        else
        {
            $user->offers()->attatch($request->offer_id);
        }
        return back();
    }
    public function rollback( Request $request ) {

        if( ! session()->has('orig_user')){
            return back();
        }

        Auth::loginUsingId(session()->get('orig_user'));

        session()->forget('orig_user');

        return redirect()->route('manager.affiliate.index');

    }
    public function switch(Request $request, $id) {

        if( auth()->id() != $id ) {

            session()->put( 'orig_user', auth()->id() );

            $user = Auth::loginUsingId($id);
        }

        return redirect()->route('affiliate.dashboard');
    }
}
