<?php

namespace App\Http\Controllers\Manager;

use App\User;
use App\Offer;
use App\Device;
use App\Country;
use App\Category;
use App\Advertiser;
use App\OfferApplication;
use Illuminate\Http\Request;
use App\Http\Requests\CreateOffer;
use App\Http\Requests\UpdateOffer;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Notification;
use App\Notifications\OfferApplicationApproved;

class OfferController extends Controller
{
    public function index()
    {
        $offers = Offer::orderBy('id','desc')->paginate(20);
        $categories = Category::all();
        $countries = Country::all();
        $devices = Device::all();

        return view('manager.offer.index',compact('offers','categories','countries','devices'));
    }
    public function show($id)
    {
        $user_id = User::where('manager_id', Auth::user()->id)->pluck('id')->toArray();
        $offer = Offer::findOrFail($id);
        $affiliates = User::whereIn('id',$user_id)->where('role','affiliate')->get();
        return view('manager.offer.show',compact('offer','affiliates'));
    }
    public function application(Request $request)
    {
        $user_id = User::where('manager_id', Auth::user()->id)->pluck('id')->toArray();
        $offer_id = [];
        if ($request->filter) {
            $user_id = $request->get('user_id');
            $offer_id = $request->get('offer_id');
            $applications = OfferApplication::where('status','false')->orderBy('id', 'DESC')
                ->when($user_id, function ($query, $user_id) {
                    return $query->whereIn('user_id', $user_id);
                })->when($offer_id, function ($query, $offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                })->paginate(20);
        }else{
            $applications = OfferApplication::where('status','false')->orderBy('id', 'DESC')->paginate(20);
        }
        $users = User::whereIn('id',$user_id)->where('role','affiliate')->where('status','active')->get();
        $offers = Offer::where('status','requestApproved')->get();
        return view('manager.offer.application',compact('applications','users','offers'));
    }
    public function approved($id)
    {
        $application = OfferApplication::find($id);
        $application->update([
            'status' => true
        ]);
        $user = User::find($application->user_id);
        Notification::send($user , new OfferApplicationApproved($application));
        return back()->with('success','Offer Application Approved Successfully');
    }
}
