<?php

namespace App\Http\Controllers\Manager;

use App\Advertiser;
use App\Country;
use App\Http\Controllers\Controller;
use App\Offer;
use App\Report;
use App\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReportController extends Controller
{
    public function day(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = User::where('manager_id',Auth::id())->distinct()->pluck('id')->toArray();
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id') ?? User::where('manager_id',Auth::id())->distinct()->pluck('id')->toArray();
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }

        $total = Report::managerTotal($date_from,$date_to, $offer_id, $country_id, $user_id);

        $period = \Carbon\CarbonPeriod::create($date_from, $date_to);
        $reports = [];
        foreach ($period as $date) {

            $query = Report::where('date', $date->toDateString())
                ->when(!empty($offer_id), function ($query) use ($offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                })->whereIn('user_id', $user_id)
                ->when(!empty($country_id), function ($query) use ($country_id) {
                    return $query->whereIn('country_id', $country_id);
                })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                    return $query->whereHas('advertiser', function ($advertiser_id) use ($query) {
                        $query->where('advertiser_id', $advertiser_id);
                    });
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $revenue = $query->where('status','approved')->sum('revenue');
            $payout = $query->where('status','approved')->sum('payout');
            $profit = $query->where('status','approved')->sum('profit');
            $reports[$date->toDateString()] = compact('click', 'unique', 'conversion', 'revenue', 'payout', 'profit');
        }
        $countries = Country::all();
        $users = User::where('manager_id',Auth::id())->get();
        $offers = Offer::all();
        return view('manager.report.day', compact('countries','users','offers','reports','total'));
    }

    public function offer(Request $request)
    {
        $offer_id = Report::query()->pluck('offer_id')->unique()->toArray();
        $offers = $offer_id;
        $country_id = [];
        $user_id = User::where('manager_id',Auth::id())->distinct()->pluck('id')->toArray();
        $advertiser_id = [];
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id') ?? User::where('manager_id',Auth::id())->distinct()->pluck('id')->toArray();
            $country_id = $request->get('country_id');
            $advertiser_id = $request->get('advertiser_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }

        $total = Report::managerTotal($date_from,$date_to, $offer_id, $country_id, $user_id);

        // Initialize reports array
        $reports = [];

        foreach ($offers as $offer_id) {
            $query = Report::where('offer_id', $offer_id)
                ->whereBetween('date', [$date_from, $date_to])
                ->whereIn('user_id',$user_id )
                ->when(!empty($country_id), function ($query) use ($country_id) {
                    return $query->whereIn('country_id', $country_id);
                })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                    return $query->whereHas('advertiser', function ($advertiser_id) use ($query) {
                        $query->where('advertiser_id', $advertiser_id);
                    });
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $revenue = $query->where('status','approved')->sum('revenue');
            $payout = $query->where('status','approved')->sum('payout');
            $profit = $query->where('status','approved')->sum('profit');
            $reports[$offer_id] = compact('click', 'unique', 'conversion', 'revenue', 'payout', 'profit');
        }
        $countries = Country::all();
        $users = User::where('manager_id',Auth::id())->get();
        $advertisers = Advertiser::all();
        $offers = Offer::all();
        return view('manager.report.offer', compact('countries','users','offers','advertisers','reports','total'));
    }

    public function country(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = User::where('manager_id',Auth::id())->distinct()->pluck('id')->toArray();
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }

        $total = Report::managerTotal($date_from,$date_to, $offer_id, $country_id, $user_id);
        $countries = $request->country_id ?? Report::query()->distinct()->pluck('country_id');
        $reports = [];
        foreach ($countries as $country_id) {
            $query = Report::where('country_id',$country_id)
                ->whereBetween('date', [$date_from, $date_to])
                ->whereIn('user_id', $user_id)
                ->when(!empty($offer_id), function ($query) use ($offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $payout = $query->where('status','approved')->sum('payout');
            $reports[$country_id] = compact('click', 'unique', 'conversion', 'payout');
        }
        $countries = Country::all();
        $users = User::where('manager_id',Auth::id())->get();
        $offers = Offer::all();
        return view('manager.report.country', compact('countries','users','offers','reports','total'));
    }

    public function aff_sub_1(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = User::where('manager_id',Auth::id())->distinct()->pluck('id')->toArray();
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $total = Report::managerTotal($date_from,$date_to, $offer_id, $country_id, $user_id);
        $aff_sub_1 = Report::query()->distinct()->pluck('aff_sub_1')->toArray();
        $reports = [];
        foreach ($aff_sub_1 as $aff_sub_1) {
            $query = Report::where('aff_sub_1',$aff_sub_1)
                ->whereBetween('date', [$date_from, $date_to])
                ->whereIn('user_id', $user_id)
                ->when(!empty($offer_id), function ($query) use ($offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $payout = $query->where('status','approved')->sum('payout');
            $reports[$aff_sub_1] = compact('click', 'unique', 'conversion', 'payout');
        }
        $countries = Country::all();
        $users = User::where('manager_id',Auth::id())->get();
        $offers = Offer::all();
        return view('manager.report.aff_sub_1', compact('countries','users','offers','reports','total'));

    }

    public function aff_sub_2(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = User::where('manager_id',Auth::id())->distinct()->pluck('id')->toArray();
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $total = Report::managerTotal($date_from,$date_to, $offer_id, $country_id, $user_id);
        $aff_sub_2 = Report::query()->distinct()->pluck('aff_sub_2')->toArray();
        $reports = [];
        foreach ($aff_sub_2 as $aff_sub_2) {
            $query = Report::where('aff_sub_2',$aff_sub_2)
                ->whereBetween('date', [$date_from, $date_to])
                ->whereIn('user_id', $user_id)
                ->when(!empty($offer_id), function ($query) use ($offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $payout = $query->where('status','approved')->sum('payout');
            $reports[$aff_sub_2] = compact('click', 'unique', 'conversion', 'payout');
        }
        $countries = Country::all();
        $users = User::where('manager_id',Auth::id())->get();
        $offers = Offer::all();
        return view('manager.report.aff_sub_2', compact('countries','users','offers','reports','total'));

    }

    public function aff_sub_3(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = User::where('manager_id',Auth::id())->distinct()->pluck('id')->toArray();
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $total = Report::managerTotal($date_from,$date_to, $offer_id, $country_id, $user_id);
        $aff_sub_3 = Report::query()->distinct()->pluck('aff_sub_3')->toArray();
        $reports = [];
        foreach ($aff_sub_3 as $aff_sub_3) {
            $query = Report::where('aff_sub_3',$aff_sub_3)
                ->whereBetween('date', [$date_from, $date_to])
                ->whereIn('user_id', $user_id)
                ->when(!empty($offer_id), function ($query) use ($offer_id) {
                    return $query->whereIn('offer_id', $offer_id);
                });
            $click = $query->sum('click');
            $unique = $query->sum('unique');
            $conversion = $query->where('status','approved')->count();
            $payout = $query->where('status','approved')->sum('payout');
            $reports[$aff_sub_3] = compact('click', 'unique', 'conversion', 'payout');
        }
        $countries = Country::all();
        $users = User::where('manager_id',Auth::id())->get();
        $offers = Offer::all();
        return view('manager.report.aff_sub_3', compact('countries','users','offers','reports','total'));

    }

    public function click(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = User::where('manager_id',Auth::id())->distinct()->pluck('id')->toArray();
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $query = Report::whereBetween('date',[$date_from,$date_to])
            ->where('status','click')
            ->whereIn('user_id',$user_id)
            ->when(!empty($offer_id), function ($query) use ($offer_id) {
                return $query->whereIn('offer_id', $offer_id);
            })->when(!empty($country_id), function ($query) use ($country_id) {
                return $query->whereIn('country_id', $country_id);
            });
        $clicks = $query->paginate(30);
        $total = $query->count();
        $countries = Country::all();
        $users = User::where('manager_id',Auth::id())->get();
        $offers = Offer::all();
        return view('manager.report.click', compact('countries','users','offers','clicks','total'));
    }

    public function conversion(Request $request)
    {
        $offer_id = [];
        $country_id = [];
        $user_id = User::where('manager_id',Auth::id())->distinct()->pluck('id')->toArray();
        if (isset($request->date_filter)) {
            $parts = explode(' - ', $request->date_filter);
            $date_from = $parts[0];
            $date_to = $parts[1];
            $offer_id = $request->get('offer_id');
            $user_id = $request->get('user_id');
            $country_id = $request->get('country_id');
        } else {
            $carbon_date_from = new Carbon('last Monday');
            $date_from = $carbon_date_from->toDateString();
            $carbon_date_to = new Carbon('this Sunday');
            $date_to = $carbon_date_to->toDateString();
        }
        $query = Report::whereBetween('date',[$date_from,$date_to])
            ->where('status','approved')
            ->whereIn('user_id',$user_id)
            ->when(!empty($offer_id), function ($query) use ($offer_id) {
                return $query->whereIn('offer_id', $offer_id);
            })->when(!empty($country_id), function ($query) use ($country_id) {
                return $query->whereIn('country_id', $country_id);
            });
        $conversions = $query->paginate(30);
        $total = $query->count();
        $countries = Country::all();
        $users = User::where('manager_id',Auth::id())->get();
        $offers = Offer::all();
        return view('manager.report.conversion', compact('countries','users','offers','conversions','total'));
    }
}
