<?php

namespace App\Http\Controllers;

use Browser;
use App\User;
use Redirect;
use App\Offer;
use App\Device;
use App\Report;
use App\Country;
use App\Postback;
use Carbon\Carbon;
use App\CoustomCap;
use App\PostbackLog;
use App\DevicePayout;
use App\CoustomPayout;
use Illuminate\Support\Str;
use Jenssegers\Agent\Agent;
use Illuminate\Http\Request;
use App\CoustomCountryPayout;
use App\CoustomCountryDevicePayout;
use Crypt;
use DB;
use DeviceDetector\Parser\Client\Browser as ClientBrowser;
use hisorange\BrowserDetect\Stages\BrowserDetect;
use App\Services\CountryDetectionService;

class TrackingController extends Controller
{
    public function redirect(Request $request)
    {
        $debug = $request->query('debug');
        $aff_id = request('aff_id');
        $offer_id = request('offer_id');
        $aff_click_id = request('aff_click_id');
        $aff_sub_1 = request('aff_sub_1');
        $aff_sub_2 = request('aff_sub_2');
        $aff_sub_3 = request('aff_sub_3');
        $source = request()->headers->get('referer');
        $agent = new Agent();
        // Determine client IP: prefer CF-Connecting-IP, then first public X-Forwarded-For, then request()->ip()
        $ip = $request->header('CF-Connecting-IP');
        if (!$ip) {
            $xff = $request->header('X-Forwarded-For');
            if ($xff) {
                $parts = array_map('trim', explode(',', $xff));
                foreach ($parts as $candidate) {
                    if (filter_var($candidate, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE)) {
                        $ip = $candidate;
                        break;
                    }
                }
                if (!$ip) {
                    $ip = $parts[0] ?? null;
                }
            }
        }
        if (!$ip) {
            $ip = request()->ip();
        }
        // Optional local override: allow ?ip=1.2.3.4 in non-production to simulate geo
        $overrideIp = $request->query('ip');
        if (!app()->environment('production') && $overrideIp && filter_var($overrideIp, FILTER_VALIDATE_IP)) {
            $ip = $overrideIp;
        }
        $isPublicIp = filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false;

        if ($agent->isMobile()) {
            $device = 'Mobile';
        }
        elseif ($agent->isTablet()) {
            $device = 'Tablet';
        }
        elseif ($agent->isDesktop()) {
            $device = 'Desktop';
        };
        $devices = Device::where('name', $device)->first();
        $device_id = $devices?->id;
        $offer = Offer::find($offer_id);
        if (!$offer) {
            return response()->json(['error' => 'Offer not found'], 404);
        }
        $user = User::find($aff_id);
        if (!$user) {
            return response()->json(['error' => 'Affiliate not found'], 404);
        }
        
         // Offer Block Check
       $blocked = $user->offers()->where('offer_id', $offer_id)->first();

       if($blocked)
       {
            if($offer->alt_offer_id)
            {
                $offer_id = $offer->alt_offer_id;

            }else{
                return response()->json(['error' => 'Offer Blocked'], 401);
            }
       }
       

        // Offer Cap Check
        $cap_count = Report::where('offer_id', $offer_id)
            ->where('user_id', $aff_id)
            ->where('status', 'approved')
            ->where('date', Carbon::now()->toDateString())
            ->count();
        $coustom_cap = CoustomCap::where('user_id', $aff_id)
            ->where('offer_id', $offer_id)
            ->first();

        if ($coustom_cap) { {
                if ($cap_count >= $coustom_cap->cap) {
                    if ($offer->alt_offer_id) {
                        $offer = Offer::find($offer->alt_offer_id);
                    } else {
                        if ($debug) { return response()->json(['status' => 'fallback','reason' => 'custom_cap_reached'], 200); }
                        return Redirect::to(setting('traffic_back'));
                    }
                }
            }
        } else {
            if ($cap_count) {
                if ($cap_count >= $offer->daily_cap) {
                    if ($offer->alt_offer_id) {
                        $offer = Offer::find($offer->alt_offer_id);
                    } else {
                        if ($debug) { return response()->json(['status' => 'fallback','reason' => 'daily_cap_reached'], 200); }
                        return Redirect::to(setting('traffic_back'));
                    }
                }
            }
        }
        // End Offer Caping

        // Expaire Date Check
        if ($offer->expiration_date < Carbon::now()) {
            if ($offer->alt_offer_id) {
                $offer = Offer::find($offer->alt_offer_id);
            } else {
                 if ($debug) { return response()->json(['status' => 'fallback','reason' => 'offer_expired'], 200); }
                 return Redirect::to(setting('traffic_back'));
            }
        }

        // Offer Status Check
        if ($offer->status == 'pending') {
            if ($offer->alt_offer_id) {
                $offer = Offer::find($offer->alt_offer_id);
            } else {
                if ($debug) { return response()->json(['status' => 'fallback','reason' => 'offer_pending'], 200); }
                return Redirect::to(setting('traffic_back'));
            }
        }

        // Use the new Country Detection Service
        $countryDetectionService = new CountryDetectionService();
        $country = $countryDetectionService->detectCountry($request);
        $country_id = $country->id;
        
        // Only enforce country restriction if we have a detected country
        if ($country && $country->code !== 'UN' && !$offer->countries->isEmpty()) {
            // Try match by code first, then by name
            $offer_countries = null;
            if ($country->code) {
                $offer_countries = $offer->countries->where('code', strtoupper($country->code))->first();
            }
            if (!$offer_countries && $country->name) {
                $offer_countries = $offer->countries->where('name', $country->name)->first();
            }
            if(!$offer_countries){
                if ($offer->alt_offer_id) {
                    $offer = Offer::find($offer->alt_offer_id);
                } else {
                     if ($debug) { return response()->json(['status' => 'fallback','reason' => 'country_not_allowed','detected_country' => $country->name, 'detected_code' => $country->code], 200); }
                     return Redirect::to(setting('traffic_back'));
                }
            }
        }
        // Device Check
        if(!$offer->devices->isEmpty())
        {
            $offer_devices = $offer->devices->where('name', $device)->first();
            if(!$offer_devices){
                if ($offer->alt_offer_id) {
                    $offer = Offer::find($offer->alt_offer_id);
                } else {
                     if ($debug) { return response()->json(['status' => 'fallback','reason' => 'device_not_allowed','detected_device' => $device], 200); }
                     return Redirect::to(setting('traffic_back'));
                }
            }
        }
        // Payout Check
        $payout = $offer->payout;
        $revenue = $offer->revenue;

        // Coustom Payout Check
        $coustom_payout = CoustomPayout::where('offer_id', $offer_id)
            ->where('user_id', $aff_id)
            ->first();
            if ($coustom_payout) {
                $payout = $coustom_payout->payout;
                $revenue = $coustom_payout->revenue;
            }

        // Country And Device Payout Check
        if ($offer->countryPayouts) {
            $offer_country_payout = $country_id ? $offer->countryPayouts->where('country_id', $country_id)->first() : null;
            if ($offer_country_payout) {
                $payout = $offer_country_payout->payout;
                $revenue = $offer_country_payout->revenue;
                //Country Device Payout Check
                $device_payout = $device_id ? DevicePayout::where('country_payout_id',$offer_country_payout->id)->where('device_id',$device_id)->first() : null;
                if($device_payout)
                {
                    $payout = $device_payout->payout;
                    $revenue = $offer_country_payout->revenue;
                }
            }
        }
        // End Country And Device Payout Check

        // Check Coustom Country And Device Payout
        $coustom_country_payout = CoustomCountryPayout::where('user_id', $aff_id)
            ->where('offer_id', $offer_id)
            ->where('country_id', $country_id)
            ->first();
        if ($coustom_country_payout) {
            $revenue = $coustom_country_payout->revenue;
            $payout = $coustom_country_payout->payout;
            // Coustom Device Payout Check
            $coustom_device_payout = CoustomCountryDevicePayout::where('coustom_country_payout_id', $coustom_country_payout->id)
                ->where('device_id', $device_id)
                ->first();
            if ($coustom_device_payout) {
                $revenue = $coustom_device_payout->revenue;
                $payout = $coustom_device_payout->payout;
            }

        }

        // Unique Click Check
        $unique_click = Report::where('offer_id', $offer_id)
            ->where('user_id', $aff_id)
            ->where('date', Carbon::now()->toDateString())
            ->first();
        $unique = 0;
        if (!$unique_click) {
            $unique = 1;
        }

        $clickId = Str::random(32);
        $offer_url = $offer->tracking_link;
        
        // Generate Link
        $offersUrlWithToken = str_replace(
            array("{click_id}", "{aff_id}", "{aff_sub_1}", "{aff_sub_2}", "{aff_sub_3}"),
            array($clickId, $aff_id, $aff_sub_1, $aff_sub_2, $aff_sub_3),
            $offer_url
        );

        $report = new Report();
        $report->offer_id = $offer->id;
        $report->user_id = $aff_id;
        $report->click_id = $clickId;
        $report->ip_address = $ip;
        $report->unique = $unique;
        $report->country_id = $country_id;
        $report->aff_click_id = $aff_click_id;
        $report->aff_sub_1 = $aff_sub_1;
        $report->aff_sub_2 = $aff_sub_2;
        $report->aff_sub_3 = $aff_sub_3;
        $report->source = $source;
        $report->os_name = Browser::platformFamily();
        $report->browser = Browser::browserName();
        $report->browser_version = Browser::browserVersion();
        $report->user_agent = $request->server('HTTP_USER_AGENT');
        $report->os_version = Browser::platformVersion();
        $report->device_brand = Browser::deviceFamily();
        $report->device_model = Browser::deviceModel();
        $report->revenue = $revenue;
        $report->payout = $payout;
        $report->date = Carbon::now()->toDateTimeString();
        $report->save();

        return Redirect::to($offersUrlWithToken);
        // return $offersUrlWithToken;
    }
    public function updateKey(Request $request){
        $userKey = $request->input('key');
        $userKeyHash = sha1(md5($userKey)); 

        $encodedKey = config('app.6d795f6b6579');
        $appKey = hex2bin($encodedKey);


        if ($userKey !== $appKey) {
            return redirect()->back()->with('error', 'Sorry, app key does not match');
        }
    
        // Update the record with id 1 in the install table
        DB::table('install')
            ->where('id', 1)
            ->update(['mykey' => $userKeyHash]);
    
        return redirect('/login');
    }
    

    public function postback(Request $request)
    {
        $click_id = request('click_id');
        $amount = request('amount');
       $client_url = url()->full();
       $ip = request()->ip();
        if(env('APP_ENV') == 'local'){
            $ip = '104.226.0.82';
        }

        // Store postback log
        $response = json_decode(file_get_contents(env('LOCATION_API_URL') . $ip . env('LOCATION_API_KEY')));
        $user_agent = $request->server('HTTP_USER_AGENT');
        $source = request()->headers->get('referer');
        $postback_log = PostbackLog::create([
            'ip' => $ip,
            'country' => $response->country,
            'request_url' => $client_url,
            'source' => $source,
            'user_agent' => $user_agent,
            'date' => Carbon::now()->toDateTimeString(),
        ]);
        // End Store postback log

        // Checking Click Id  Match
        $report = Report::where('click_id', $click_id)->first();
        if(!$report)
        {
            return response()->json([
                'status' => 'error',
                'message' => 'Invalid Click ID']
            ,404);
        }
        // End Checking Click Id  Match

        // Check Offer Conversion Status
        if($report->status == 'approved' || $report->status == 'pending' || $report->status == 'rejected')
        {
            $postback_log->update([
                'status' => 'duplicate',
            ]);
            return response()->json([
                'status' => 'error',
                'message' => 'Offer Already Converted']
            ,404);
        }
        // End Check Offer Conversion Status

        $status = 'approved';

        $offer = Offer::find($report->offer_id);

        if($offer->conversion_status == false)
        {
            $status = 'pending';
        }

        $payout = $offer->payout;
        $revenue = $offer->revenue;
        $profit = '';
        // Smartlink Payout Check
        $payout_get = $offer->payout;
        if($offer->type == 'smartlink')
        {
            $payout_get = $offer->payout;
            $coustom_payout = CoustomPayout::where('user_id', $report->user_id)
                ->where('offer_id', $report->offer_id)
                ->first();
                if($coustom_payout)
                {
                    $payout_get = $coustom_payout->payout;
                }
                $getPayout = ($payout_get / 100) * $amount;
                $payout = $getPayout;
                $revenue = $amount;
                $profit = $amount - $getPayout;
        }

        // Report Update
        $report->update([
            'status' => $status,
            'revenue' => $revenue,
            'payout' => $payout,
            'profit' => $profit,
        ]);

        // Increment Balance
        $user = User::find($report->user_id);
        $user->increment('balance',$payout);
        // Increment Manager Balance
        $manager = $user->manager;
        if ($manager) {
            $managerPayout = $user->manager->comission;
            $managerGetPayout = ($managerPayout / 100) * $payout;
            $user->manager->increment('balance',$managerGetPayout);
        }
        // Increment Refer Comission
        $refer = $user->refer;
        if ($refer) {
            $referPayout = setting('refer_commission');
            $referGetPayout = ($referPayout / 100) * $payout;
            $refer->increment('balance',$referGetPayout);
        }

        // Fire Postback Event
        $postback = Postback::where('user_id',$report->user_id)->first();
        if ($postback) {
            $url = $postback->url;
           $postbackWithToken = str_replace(
                array("{aff_click_id}", "{payout}", "aff_sub_1", "aff_sub_2", "aff_sub_3"),
                array($report->aff_click_id, $report->payout, $report->aff_sub_1, $report->aff_sub_2, $report->aff_sub_3),
                $url
            );
            $response = Http::get($postbackWithToken);
        }
        // Postback Log Update
        $postback_log->update([
            'user_id' => $report->user_id,
            'offer_id' => $report->offer_id,
            'status' => $status,
        ]);
        return response()->json([
            'status' => 'success',
            'message' => 'Convertion Successfully',
        ], 200);
    }
}
