<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    function doLogin(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'email' => 'required|email',   // required and email format validation
            'password' => 'required', // required and number field validation

        ]); // create the validations
        if ($validator->fails())   //check all validations are fine, if not then redirect and show error messages
        {
            return response()->json($validator->errors(),422);
            // validation failed return with 422 status

        } else {


            if (\Auth::attempt($request->only(["email", "password"]))) {

                // Check Role base redirection
                $user = Auth::user();
                if ($user->role == "admin") {

                    $url = route('admin.dashboard');

                }elseif ($user->role == "affiliate") {

                    $url = route('affiliate.dashboard');

                }elseif($user->role == "manager"){

                    $url = route('manager.dashboard');
                }
                return response()->json([
                    "status"=>'success',
                    "url"=>$url
                ]);

            } else {
                return response()->json([["Invalid credentials"]],422);
            }
        }
    }

}
