<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CheckMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
{
    // Check if the table exists in the database
    if (!Schema::hasTable('install')) {
        return redirect()->route('install'); // Redirect to the install route
    }

    $key = config('app.my_key');

    // Retrieve data from the table
    $data = DB::table('install')
        ->where('id', 1)
        ->first();

    if ($data->mykey !== $key) {
        return redirect()->route('install');
    }

    return $next($request);
}

}
