<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
class GlobalFunctionMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Avoid redirect loops: skip checks on the installer route/path
        if ($request->routeIs('install') || $request->is('install')) {
            return $next($request);
        }

        $response = $this->executeOnEveryPageLoad($request);
        if ($response) {
            return $response;
        }

        return $next($request);
    }

    private function executeOnEveryPageLoad(Request $request)
    {
        // Your code to execute on every page load
        if (!Schema::hasTable('install')) {
            return $this->redirectToInstall();
        }

        $key = config('app.my_key');

        $data = DB::table('install')
            ->where('id', 1)
            ->first();

        if (!$data || $data->mykey !== $key) {
            return $this->redirectToInstall();
        }

        return null;
    }
    
    private function redirectToInstall()
    {
        $router = app('router');
        if (method_exists($router, 'has') && $router->has('install')) {
            return redirect()->route('install');
        }

        return redirect('/install');
    }
}
