<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class UserStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // Skip user status check for logout route to prevent 503 errors
        if ($request->routeIs('logout')) {
            return $next($request);
        }
        
        if(Auth::check() && Auth::user()->status == "pending"){
            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();
            return redirect()->route('login')->with('error', 'Your account inactive, please contact Support.');
        }elseif (Auth::check() && Auth::user()->status == "suspend") {
            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();
            return redirect()->route('login')->with('error', 'Your account suspend, please contact Support.');
        }
        return $next($request);
    }
}
