<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateManager extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => 'required|string|max:255|unique:users',
            'last_name' => 'required|string|max:255|unique:users',
            'skype' => 'required|string|max:255',
            'country_id' => 'required|integer',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6|confirmed',
            'avater' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'comission' => 'required'
        ];
    }
}
