<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class GeneralSetting extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'site_title' => 'required|alpha_dash|max:255',
            'tracking_domain' => 'required|url|max:255',
            'site_time_zone' => 'required|max:255',
            'affiliate_register' => 'required|boolean',
            'affiliate_register_status' => 'required|boolean',
            'site_conversion_status' => 'required|boolean',
            'refer_commission' => 'required|numeric',
            'copyright_text' => 'required|max:255',
        ];
    }
}
