<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class MailUpdate extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'mail_driver' => 'required|alpha_dash|max:255',
            'mail_host' => 'required|max:255',
            'mail_port' => 'required|max:255',
            'mail_username' => 'required|max:255',
            'mail_password' => 'required|max:255',
            'mail_encryption' => 'required|max:255',
            'mail_from_address' => 'required|email|max:255',
        ];
    }
}
