<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateOffer extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => Rule::unique('offers')->ignore($this->id),
            'description' => 'required|string',
            'preview_link' => 'required|url',
            'tracking_link' => 'required|string',
            'type' => 'required|string',
            'status' => 'required|string',
            'revenue' => 'required|numeric',
            'payout' => 'required|numeric',
            'conversion_status' => 'required|boolean',
            'daily_cap' => 'required|numeric',
            'expiration_date' => 'required|date',
        ];
    }
}
