<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UserUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'skype' => 'required|string|max:255',
            'country_id' => 'required|integer',
            'manager_id' => 'required|integer',
            'email' => Rule::unique('users')->ignore($this->id),
            'avater' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ];

    }

}
