<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Offer extends Model implements HasMedia
{
    use InteractsWithMedia;


    protected $fillable = ['is_smart','top_offer','traffic_allowed'];

    // protected $fillable=['is_smart'];

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('avater')->singleFile();
    }


    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function countries()
    {
        return $this->belongsToMany(Country::class,'country_offer','offer_id','country_id');
    }

    public function devices()
    {
        return $this->belongsToMany(Device::class,'device_offer','offer_id','device_id');
    }

    public function advertiser()
    {
        return $this->belongsTo(Advertiser::class,'advertiser_id');
    }

    public function countryPayouts()
    {
        return $this->hasMany(CountryPayout::class);
    }

    public function coustomPayouts()
    {
        return $this->hasMany(CoustomPayout::class);
    }

    public function caps()
    {
        return $this->hasMany(CoustomCap::class);
    }

    public function coustomCountryPayouts()
    {
        return $this->hasMany(CoustomCountryPayout::class);
    }
    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function applications()
    {
        return $this->hasMany(OfferApplication::class);
    }
    public function reports()
    {
        return $this->hasMany(Report::class);
    }
    public function postbackLog()
    {
        return $this->hasMany(PostbackLog::class);
    }
    public function verticle()
    {
        return $this->belongsTo(Verticle::class);
    }
    public function optimize()
    {
        return $this->hasOne(Optimize::class);
    }

}
