<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class GlobalFunctionServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Define the function that can be called from any page
        if (!function_exists('myGlobalFunction')) {
            function myGlobalFunction() {
                // Avoid acting on the installer to prevent loops
                if (request()->routeIs('install') || request()->is('install')) {
                    return;
                }

                // Domain check (disabled redirect; middleware handles redirect)
                $currentUrl = url()->current();
                $encodedAllowedUrl = config('app.616c6c6f7765645f75726c');
                $allowedUrl = $encodedAllowedUrl ? hex2bin($encodedAllowedUrl) : null;
                if ($allowedUrl) {
                    $currentParsedUrl = parse_url($currentUrl);
                    if (isset($currentParsedUrl['scheme'], $currentParsedUrl['host'])) {
                        $currentMainDomain = $currentParsedUrl['scheme'] . '://' . $currentParsedUrl['host'] . '/';
                        // If mismatch, do nothing here; middleware enforces redirect
                    }
                }

                // Installation table/key checks (no redirect here)
                if (!Schema::hasTable('install')) {
                    return;
                }
                $encodedKey = config('app.6d795f6b6579');
                $key = $encodedKey ? hex2bin($encodedKey) : null;
                $data = DB::table('install')->where('id', 1)->first();
                if ($data && $key) {
                    $hashedKey = sha1(md5($key));
                    // If mismatch, do nothing; middleware will handle redirect
                }
            }
        }
        view()->share('myGlobalFunction', 'myGlobalFunction');
    }
}
