<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class Report extends Model
{
    protected $guarded = ['id'];
    protected $fillable=['processed'];
    public static function total($advertiser_id, $date_from, $date_to, $offer_id, $country_id, $user_id): array
    {
        $query = Report::whereBetween('date',[$date_from, $date_to])
            ->when(!empty($offer_id), function ($query) use ($offer_id) {
                return $query->whereIn('offer_id', $offer_id);
            })
            ->when(!empty($user_id), function ($query) use ($user_id) {
                return $query->whereIn('user_id', $user_id);
            })
            ->when(!empty($country_id), function ($query) use ($country_id) {
                return $query->whereIn('country_id', $country_id);
            })->when(!empty($advertiser_id), function ($query) use ($advertiser_id) {
                return $query->whereHas('offer', function ($query) use ($advertiser_id) {
                    $query->whereIn('advertiser_id', $advertiser_id);
                });
            });
        $clicks = $query->sum('click');
        $uniques = $query->sum('unique');
        $conversions = $query->where('status','approved')->count();
        $revenues = $query->where('status','approved')->sum('revenue');
        $payouts = $query->where('status','approved')->whereNotNull('payout')->where('payout', '>', 0)->sum('payout');
        $profits = $query->where('status','approved')->sum('profit');
        $data = [
            'clicks' => $clicks,
            'uniques' => $uniques,
            'conversions' => $conversions,
            'revenues' => $revenues,
            'payouts' => $payouts,
            'profits' => $profits,
        ];
        return $data;
    }


    public static function affiliateTotal($date_from, $date_to, $offer_id, $country_id): array
    {
        $query = Report::whereBetween('date',[$date_from, $date_to])
            ->where('user_id',Auth::id())
            ->when(!empty($offer_id), function ($query) use ($offer_id) {
                return $query->whereIn('offer_id', $offer_id);
            })
            ->when(!empty($country_id), function ($query) use ($country_id) {
                return $query->whereIn('country_id', $country_id);
            });
        $clicks = $query->sum('click');
        $uniques = $query->sum('unique');
        $conversions = $query->where('status','approved')->count();
        $revenues = $query->where('status','approved')->sum('revenue');
        $payouts = $query->where('status','approved')->whereNotNull('payout')->where('payout', '>', 0)->sum('payout');
        $profits = $query->where('status','approved')->sum('profit');
        $data = [
            'clicks' => $clicks,
            'uniques' => $uniques,
            'conversions' => $conversions,
            'revenues' => $revenues,
            'payouts' => $payouts,
            'profits' => $profits,
        ];
        return $data;
    }


    public static function managerTotal( $date_from, $date_to, $offer_id, $country_id, $user_id): array
    {
        $query = Report::whereBetween('date',[$date_from, $date_to])
            ->when(!empty($offer_id), function ($query) use ($offer_id) {
                return $query->whereIn('offer_id', $offer_id);
            })
            ->whereIn('user_id', $user_id)
            ->when(!empty($country_id), function ($query) use ($country_id) {
                return $query->whereIn('country_id', $country_id);
            });
        $clicks = $query->sum('click');
        $uniques = $query->sum('unique');
        $conversions = $query->where('status','approved')->count();
        $payouts = $query->where('status','approved')->whereNotNull('payout')->where('payout', '>', 0)->sum('payout');
        $data = [
            'clicks' => $clicks,
            'uniques' => $uniques,
            'conversions' => $conversions,
            'payouts' => $payouts,
        ];
        return $data;
    }



    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function offer()
    {
        return $this->belongsTo(Offer::class);
    }
    public function country()
    {
        return $this->belongsTo(Country::class);
    }
}
