<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TopOffer extends Model
{
    protected $fillable = [
        'offer_id',
        'sort_order',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the offer that belongs to this top offer entry
     */
    public function offer()
    {
        return $this->belongsTo(Offer::class);
    }

    /**
     * Scope to get only active top offers
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope to order by sort order
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order', 'asc');
    }

    /**
     * Get active top offers with their offer details
     */
    public static function getActiveTopOffers($limit = 5)
    {
        return self::active()
            ->ordered()
            ->with(['offer.category', 'offer.advertiser'])
            ->limit($limit)
            ->get();
    }
}
