<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class User extends Authenticatable implements HasMedia
{
    use Notifiable,InteractsWithMedia;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = [];
    protected $fillable = ['refer_id', 'first_name', 'last_name', 'email', 'country_id', 'skype', 'password', 'role', 'status', 'manager_id'];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('avater')->singleFile();
        $this->addMediaCollection('avatar')->singleFile();
    }

    public function getAvatarUrl()
    {
        $avatarUrl = $this->getFirstMediaUrl('avatar') ?: $this->getFirstMediaUrl('avater');
        if ($avatarUrl) {
            return url('public') . $avatarUrl;
        }
        return null;
    }
    public function users()
    {
        return $this->hasMany(User::class, 'manager_id');
    }

    public function manager()
    {
        return $this->belongsTo(User::class, 'manager_id');
    }
    public function country()
    {
       return $this->belongsTo(Country::class);
    }

    public function coustomPayouts()
    {
        return $this->hasMany(CoustomPayout::class);
    }

    public function caps()
    {
        return $this->hasMany(CoustomCap::class);
    }

    public function coustomCountryPayouts()
    {
        return $this->hasMany(CoustomCountryPayout::class);
    }
    public function offers()
    {
        return $this->belongsToMany(Offer::class);
    }

    public function offerApplications()
    {
        return $this->hasMany(OfferApplication::class);
    }
    public function paymentMethod()
    {
        return $this->hasOne(PaymentMethod::class);
    }
    public function postback()
    {
        return $this->hasOne(Postback::class);
    }
    public function reports()
    {
        return $this->hasMany(Report::class);
    }
    public function postbackLog()
    {
        return $this->hasMany(PostbackLog::class);
    }

    public function invoice()
    {
        return $this->hasMany(Invoice::class);
    }

    public function answer()
    {
        return $this->hasMany(Answer::class);
    }

    public function chats()
    {
        return $this->belongsToMany(Chat::class, 'chat_participants')
                    ->withPivot('last_read_at')
                    ->withTimestamps();
    }

    public function messages()
    {
        return $this->hasMany(Message::class);
    }

}
