<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCoustomCountryDevicePayoutsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coustom_country_device_payouts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('coustom_country_payout_id')
                ->constrained('coustom_country_payouts')
                ->onDelete('cascade');
            $table->foreignId('device_id');
            $table->float('revenue');
            $table->float('payout');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coustom_country_device_payouts');
    }
}
