<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id');
            $table->foreignId('offer_id')
                ->constrained('offers');
            $table->string('click_id');
            $table->string('aff_click_id')->nullable();
            $table->integer('click')->default(1);
            $table->integer('unique')->default(0);
            $table->longText('aff_sub_1')->nullable();
            $table->longText('aff_sub_2')->nullable();
            $table->longText('aff_sub_3')->nullable();
            $table->longText('source')->nullable();
            $table->integer('fraud')->nullable();
            $table->string('os_name')->nullable();
            $table->string('browser')->nullable();
            $table->string('browser_version')->nullable();
            $table->string('user_agent')->nullable();
            $table->string('os_version')->nullable();
            $table->string('device_brand')->nullable();
            $table->string('device_model')->nullable();
            $table->string('ip_address');
            $table->foreignId('country_id');
            $table->string('geo_city')->nullable();
            $table->string('geo_region')->nullable();
            $table->float('revenue')->nullable();
            $table->float('payout')->nullable();
            $table->float('profit')->nullable();
            $table->string('status')->default('click');
            $table->date('date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reports');
    }
}
