<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePostbackLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('postback_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('offer_id')->nullable();
            $table->foreignId('user_id')->nullable();
            $table->string('ip');
            $table->string('country');
            $table->string('request_url');
            $table->string('source')->nullable();
            $table->string('user_agent')->nullable();
            $table->string('status')->default('error');
            $table->date('date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('postback_logs');
    }
}
