<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFruadReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fruad_reports', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('affiliate_id');
            $table->string('offer_id');
            $table->boolean('proxy')->default(false);
            $table->string('ISP')->nullable();
            $table->string('organization')->nullable();
            $table->unsignedBigInteger('ASN')->nullable();
            $table->string('host')->nullable();
            $table->string('country_code', 2)->nullable();
            $table->string('city')->nullable();
            $table->string('region')->nullable();
            $table->boolean('is_crawler')->default(false);
            $table->string('connection_type')->nullable();
            $table->string('zip_code', 10)->nullable();
            $table->string('timezone')->nullable();
            $table->boolean('vpn')->default(false);
            $table->boolean('tor')->default(false);
            $table->boolean('active_vpn')->default(false);
            $table->boolean('active_tor')->default(false);
            $table->boolean('recent_abuse')->default(false);
            $table->boolean('frequent_abuser')->default(false);
            $table->boolean('high_risk_attacks')->default(false);
            $table->string('abuse_velocity')->nullable();
            $table->boolean('bot_status')->default(false);
            $table->boolean('shared_connection')->default(false);
            $table->boolean('dynamic_connection')->default(false);
            $table->boolean('security_scanner')->default(false);
            $table->boolean('trusted_network')->default(false);
            $table->boolean('mobile')->default(false);
            $table->unsignedTinyInteger('fraud_score')->default(0);
            $table->string('operating_system')->nullable();
            $table->string('browser')->nullable();
            $table->string('device_model')->nullable();
            $table->string('device_brand')->nullable();
            $table->timestamps();
        
            // Adding the foreign key constraint with cascade on delete
        });
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fruad_reports');
    }
}
