<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('offers', function (Blueprint $table) {
            if (!Schema::hasColumn('offers', 'is_smart')) {
                $table->boolean('is_smart')->default(false)->after('type');
            }
            if (!Schema::hasColumn('offers', 'top_offer')) {
                $table->boolean('top_offer')->default(false)->after('is_smart');
            }
            if (!Schema::hasColumn('offers', 'traffic_allowed')) {
                $table->text('traffic_allowed')->nullable()->after('top_offer');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('offers', function (Blueprint $table) {
            if (Schema::hasColumn('offers', 'traffic_allowed')) {
                $table->dropColumn('traffic_allowed');
            }
            if (Schema::hasColumn('offers', 'top_offer')) {
                $table->dropColumn('top_offer');
            }
            if (Schema::hasColumn('offers', 'is_smart')) {
                $table->dropColumn('is_smart');
            }
        });
    }
};
