<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('install', function (Blueprint $table) {
            $table->id();
            $table->string('mykey')->nullable();
            $table->timestamps();
        });

        // Ensure an initial row exists so code that expects id=1 can update it
        DB::table('install')->insert([
            'id' => 1,
            'mykey' => null,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('install');
    }
};
