<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('media', 'generated_conversions')) {
            Schema::table('media', function (Blueprint $table) {
                $table->json('generated_conversions')->nullable();
            });
        }

        // Migrate existing data from custom_properties to generated_conversions
        try {
            Media::query()
                ->whereNull('generated_conversions')
                ->orWhere('generated_conversions', '')
                ->orWhereRaw("JSON_TYPE(generated_conversions) = 'NULL'")
                ->update([
                    'generated_conversions' => DB::raw('custom_properties->"$.generated_conversions"'),
                ]);
        } catch (\Exception $e) {
            // If migration fails, just continue - the column is added
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('media', function (Blueprint $table) {
            $table->dropColumn('generated_conversions');
        });
    }
};
