<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ConversionTestSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Target date: 10/21/2025
        $targetDate = '2025-10-21';
        
        // Create 2 conversions at 10:00 AM
        for ($i = 1; $i <= 2; $i++) {
            DB::table('reports')->insert([
                'user_id' => 2, // affiliate user
                'offer_id' => 1,
                'click_id' => 'conv_test_' . uniqid(),
                'aff_click_id' => 'aff_conv_' . uniqid(),
                'click' => 1,
                'unique' => 1,
                'aff_sub_1' => 'test_sub1',
                'aff_sub_2' => 'test_sub2',
                'aff_sub_3' => 'test_sub3',
                'source' => 'test_source',
                'fraud' => 0,
                'os_name' => 'Windows',
                'browser' => 'Chrome',
                'browser_version' => '120.0',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
                'os_version' => '10.0',
                'device_brand' => 'PC',
                'device_model' => 'Desktop',
                'ip_address' => '192.168.1.' . $i,
                'country_id' => 1,
                'geo_city' => 'New York',
                'geo_region' => 'NY',
                'revenue' => 1.20,
                'payout' => 1.10,
                'profit' => 0.10,
                'status' => 'approved', // This is a conversion
                'date' => $targetDate,
                'created_at' => Carbon::parse($targetDate . ' 10:00:00')->addMinutes($i * 5), // 10:05, 10:10
                'updated_at' => Carbon::parse($targetDate . ' 10:00:00')->addMinutes($i * 5),
            ]);
        }
        
        // Create 1 conversion at 2:00 PM (14:00)
        DB::table('reports')->insert([
            'user_id' => 2, // affiliate user
            'offer_id' => 1,
            'click_id' => 'conv_test_' . uniqid(),
            'aff_click_id' => 'aff_conv_' . uniqid(),
            'click' => 1,
            'unique' => 1,
            'aff_sub_1' => 'test_sub1',
            'aff_sub_2' => 'test_sub2',
            'aff_sub_3' => 'test_sub3',
            'source' => 'test_source',
            'fraud' => 0,
            'os_name' => 'Windows',
            'browser' => 'Chrome',
            'browser_version' => '120.0',
            'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
            'os_version' => '10.0',
            'device_brand' => 'PC',
            'device_model' => 'Desktop',
            'ip_address' => '192.168.1.100',
            'country_id' => 1,
            'geo_city' => 'New York',
            'geo_region' => 'NY',
            'revenue' => 1.20,
            'payout' => 1.10,
            'profit' => 0.10,
            'status' => 'approved', // This is a conversion
            'date' => $targetDate,
            'created_at' => Carbon::parse($targetDate . ' 14:00:00'),
            'updated_at' => Carbon::parse($targetDate . ' 14:00:00'),
        ]);
        
        // Create some clicks (non-conversions) for other hours to make the chart more realistic
        $clickHours = [8, 9, 11, 12, 13, 15, 16, 17, 18];
        foreach ($clickHours as $hour) {
            DB::table('reports')->insert([
                'user_id' => 2, // affiliate user
                'offer_id' => 1,
                'click_id' => 'click_test_' . uniqid(),
                'aff_click_id' => 'aff_click_' . uniqid(),
                'click' => 1,
                'unique' => 1,
                'aff_sub_1' => 'test_sub1',
                'aff_sub_2' => 'test_sub2',
                'aff_sub_3' => 'test_sub3',
                'source' => 'test_source',
                'fraud' => 0,
                'os_name' => 'Windows',
                'browser' => 'Chrome',
                'browser_version' => '120.0',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
                'os_version' => '10.0',
                'device_brand' => 'PC',
                'device_model' => 'Desktop',
                'ip_address' => '192.168.1.' . rand(200, 250),
                'country_id' => 1,
                'geo_city' => 'New York',
                'geo_region' => 'NY',
                'revenue' => 0,
                'payout' => 0,
                'profit' => 0,
                'status' => 'click', // This is just a click, not a conversion
                'date' => $targetDate,
                'created_at' => Carbon::parse($targetDate . ' ' . sprintf('%02d:00:00', $hour)),
                'updated_at' => Carbon::parse($targetDate . ' ' . sprintf('%02d:00:00', $hour)),
            ]);
        }
        
        echo "Created test data for {$targetDate}:\n";
        echo "- 2 conversions at 10:00 AM\n";
        echo "- 1 conversion at 2:00 PM\n";
        echo "- Clicks at various other hours\n";
    }
}
