<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ReportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create sample reports for the affiliate user (user_id = 2)
        $dates = [
            Carbon::now()->subDays(2)->toDateString(),
            Carbon::now()->subDays(1)->toDateString(),
            Carbon::now()->toDateString(),
        ];

        foreach ($dates as $date) {
            DB::table('reports')->insert([
                'user_id' => 2, // affiliate user
                'offer_id' => 1,
                'click_id' => 'test_click_' . uniqid(),
                'aff_click_id' => 'aff_click_' . uniqid(),
                'click' => 1,
                'unique' => 1,
                'aff_sub_1' => 'test_sub1',
                'aff_sub_2' => 'test_sub2',
                'aff_sub_3' => 'test_sub3',
                'source' => 'test_source',
                'fraud' => 0,
                'os_name' => 'Windows',
                'browser' => 'Chrome',
                'browser_version' => '120.0',
                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
                'os_version' => '10.0',
                'device_brand' => 'PC',
                'device_model' => 'Desktop',
                'ip_address' => '192.168.1.1',
                'country_id' => 1,
                'geo_city' => 'New York',
                'geo_region' => 'NY',
                'revenue' => 1.20,
                'payout' => 1.10,
                'profit' => 0.10,
                'status' => 'click',
                'date' => $date,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            // Add a few more reports for the same date
            for ($i = 0; $i < 3; $i++) {
                DB::table('reports')->insert([
                    'user_id' => 2, // affiliate user
                    'offer_id' => 1,
                    'click_id' => 'test_click_' . uniqid(),
                    'aff_click_id' => 'aff_click_' . uniqid(),
                    'click' => 1,
                    'unique' => 0,
                    'aff_sub_1' => 'test_sub1_' . $i,
                    'aff_sub_2' => 'test_sub2_' . $i,
                    'aff_sub_3' => 'test_sub3_' . $i,
                    'source' => 'test_source_' . $i,
                    'fraud' => 0,
                    'os_name' => 'Windows',
                    'browser' => 'Chrome',
                    'browser_version' => '120.0',
                    'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
                    'os_version' => '10.0',
                    'device_brand' => 'PC',
                    'device_model' => 'Desktop',
                    'ip_address' => '192.168.1.' . ($i + 2),
                    'country_id' => 1,
                    'geo_city' => 'New York',
                    'geo_region' => 'NY',
                    'revenue' => 1.20,
                    'payout' => 1.10,
                    'profit' => 0.10,
                    'status' => 'click',
                    'date' => $date,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
