<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\TopOffer;
use App\Offer;

class TopOfferSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first 5 active offers to use as top offers
        $offers = Offer::where('status', 'active')
            ->orWhere('status', 'requestApproved')
            ->limit(5)
            ->get();

        if ($offers->count() > 0) {
            foreach ($offers as $index => $offer) {
                TopOffer::create([
                    'offer_id' => $offer->id,
                    'sort_order' => $index + 1,
                    'is_active' => true,
                ]);
            }
            
            $this->command->info('Top offers seeded successfully with ' . $offers->count() . ' offers.');
        } else {
            $this->command->warn('No active offers found to seed as top offers.');
            $this->command->info('Please create some offers first, then run this seeder again.');
        }
    }
}
