<?php
/**
 * Cache Clearing Script for cPanel
 * Run this file through your browser to clear Laravel caches
 */

// Bootstrap Laravel
require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

echo "<h2>Laravel Cache Clearing Tool</h2>";
echo "<p>Clearing all Laravel caches...</p>";

try {
    // Clear configuration cache
    echo "<p>✓ Clearing configuration cache...</p>";
    $kernel->call('config:clear');
    
    // Clear application cache
    echo "<p>✓ Clearing application cache...</p>";
    $kernel->call('cache:clear');
    
    // Clear route cache
    echo "<p>✓ Clearing route cache...</p>";
    $kernel->call('route:clear');
    
    // Clear view cache
    echo "<p>✓ Clearing view cache...</p>";
    $kernel->call('view:clear');
    
    // Clear compiled services
    echo "<p>✓ Clearing compiled services...</p>";
    $kernel->call('clear-compiled');
    
    echo "<h3 style='color: green;'>✅ All caches cleared successfully!</h3>";
    echo "<p>Your session configuration should now be updated.</p>";
    echo "<p><strong>Important:</strong> Delete this file after use for security reasons.</p>";
    
} catch (Exception $e) {
    echo "<h3 style='color: red;'>❌ Error clearing cache:</h3>";
    echo "<p>" . $e->getMessage() . "</p>";
}
?>
