<?php
/**
 * Alternative Session Configuration for cPanel
 * Use this if database sessions don't work
 */

// Option 1: Cookie-based sessions (most reliable for cPanel)
$cookieConfig = [
    'driver' => 'cookie',
    'lifetime' => 120,
    'expire_on_close' => false,
    'encrypt' => true, // Important for security with cookies
    'cookie' => 'laravel_session',
    'path' => '/',
    'domain' => null,
    'secure' => false, // Set to true if using HTTPS
    'http_only' => true,
    'same_site' => 'lax',
];

// Option 2: File sessions with system temp directory
$fileConfig = [
    'driver' => 'file',
    'files' => sys_get_temp_dir(), // Uses system temp directory
    'lifetime' => 120,
    'expire_on_close' => false,
    'encrypt' => false,
];

// Option 3: Array sessions (for testing only)
$arrayConfig = [
    'driver' => 'array',
    'lifetime' => 120,
    'expire_on_close' => false,
    'encrypt' => false,
];

echo "<h2>Alternative Session Configurations for cPanel</h2>";
echo "<h3>Option 1: Cookie Sessions (Recommended)</h3>";
echo "<pre>" . htmlspecialchars(var_export($cookieConfig, true)) . "</pre>";

echo "<h3>Option 2: File Sessions with System Temp</h3>";
echo "<pre>" . htmlspecialchars(var_export($fileConfig, true)) . "</pre>";

echo "<h3>Option 3: Array Sessions (Testing Only)</h3>";
echo "<pre>" . htmlspecialchars(var_export($arrayConfig, true)) . "</pre>";

echo "<h3>Instructions:</h3>";
echo "<ol>";
echo "<li>Copy one of the configurations above</li>";
echo "<li>Replace the corresponding section in config/session.php</li>";
echo "<li>Run the cache clearing script</li>";
echo "</ol>";
?>
