@extends('layouts.backend.admin_sash')


@isset($affiliate)
@section('title', 'Edit Affiliate')
@else
@section('title','Create Affiliate')
@endisset


@push('css')
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
@endpush

@section('content')
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <!-- Page pre-title -->
                    <div class="page-pretitle">
                        Overview
                    </div>
                    <h2 class="page-title">
                        @yield(('title'))
                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="btn-list">
                        <a href="{{ route('admin.affiliate.index') }}" class="btn btn-primary d-none d-sm-inline-block">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <i class="fa fa-backward"></i>
                            Back
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-xl">
            <form action="{{ isset($affiliate) ? route('admin.affiliate.update',$affiliate->id) : route('admin.affiliate.store')   }}" method="post" enctype="multipart/form-data">
                @csrf
                @isset($affiliate)
                    @method('PUT')
                @endisset
                <div class="row row-cards">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Basic Info</h3>
                        </div>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">First Name</label>
                                <div>
                                    <input type="text" class="form-control" name="first_name" value="{{ $affiliate->first_name ?? old('first_name') }}" placeholder="First Name" required>
                                </div>
                                @error('first_name')
                                <div class="error">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Last Name</label>
                                <div>
                                    <input type="text" class="form-control" name="last_name"  value="{{ $affiliate->last_name ?? old('last_name') }}" placeholder="Last Name" required>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Email</label>
                                <div>
                                    <input type="email" class="form-control" name="email"  value="{{ $affiliate->email ?? old('email') }}" placeholder="Email" required>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Country</label>
                                <div>
                                    <select name="country_id" class="form-select" id="country_id" placeholder="  Select a country..." required>
                                        <option selected disabled>Select Country</option>
                                    @foreach($countries as $country)
                                        <option
                                            @isset($affiliate)
                                                {{ $affiliate->country_id == $country->id ? 'selected' : '' }}
                                            @endisset
                                            value="{{ $country->id }}">{{ $country->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Skype</label>
                                <div>
                                    <input type="text" class="form-control" name="skype"  value="{{ $affiliate->skype ?? old('skype') }}" placeholder="Skype" required>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Manager</label>
                                <div>
                                    <select name="manager_id" class="form-select" id="manager_id" placeholder="  Select a country..." required>
                                        <option selected disabled>Select Manager</option>
                                        @foreach($managers as $manager)
                                            <option
                                                @isset($affiliate)
                                                {{ $affiliate->manager_id == $manager->id ? 'selected' : '' }}
                                                @endisset
                                                value="{{ $manager->id }}">{{ $manager->first_name }} {{ $manager->last_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Password & Image</h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Status</label>
                                <div>
                                    <div class="input-icon">
                                        <select name="status" id="status" class="form-control">
                                            <option @isset($affiliate) {{ $affiliate->status == "active" ? 'selected' : '' }} @endisset value="active">Active</option>
                                            <option @isset($affiliate) {{ $affiliate->status == "pending" ? 'selected' : '' }} @endisset value="pending">Pending</option>
                                            <option @isset($affiliate) {{ $affiliate->status == "suspend" ? 'selected' : '' }} @endisset value="suspend">Suspend</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group mb-3 ">
                                <label class="form-label">Avater</label>
                                <div>
                                    <input type="file" name="avater" class="form-control">
                                </div>
                            </div>
                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary">@isset($affiliate) Update @else Create @endisset</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
    <script>
        new TomSelect('#country_id',{
            plugins: ['input_autogrow'],
        });
        new TomSelect('#manager_id',{
            plugins: ['input_autogrow'],
        });

    </script>
@endpush
